/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.collect;

import de.cuioss.tools.collect.CollectionLiterals;
import de.cuioss.tools.collect.MoreCollections;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Stream;
import lombok.Generated;

public final class CollectionBuilder<E>
implements Iterable<E> {
    private final Collection<E> collector;
    private boolean addNullValues = false;

    public CollectionBuilder(Collection<E> collector) {
        this.collector = Objects.requireNonNull(collector);
    }

    public CollectionBuilder() {
        this(new ArrayList());
    }

    public CollectionBuilder<E> addNullValues(boolean addNullValues) {
        this.addNullValues = addNullValues;
        return this;
    }

    public int size() {
        return this.collector.size();
    }

    public boolean isEmpty() {
        return this.collector.isEmpty();
    }

    public boolean contains(Object o) {
        return this.collector.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.collector.iterator();
    }

    public Stream<E> stream() {
        return this.collector.stream();
    }

    public CollectionBuilder<E> add(E e) {
        if (this.addNullValues || null != e) {
            this.collector.add(e);
        }
        return this;
    }

    public CollectionBuilder<E> add(E ... elements) {
        if (!MoreCollections.isEmpty(elements)) {
            for (E element : elements) {
                this.add(element);
            }
        }
        return this;
    }

    public CollectionBuilder<E> add(Iterable<E> elements) {
        if (!MoreCollections.isEmpty(elements)) {
            elements.forEach(this::add);
        }
        return this;
    }

    public CollectionBuilder<E> add(Collection<E> elements) {
        if (!MoreCollections.isEmpty(elements)) {
            elements.forEach(this::add);
        }
        return this;
    }

    public CollectionBuilder<E> add(Optional<E> element) {
        element.ifPresent(this::add);
        return this;
    }

    public CollectionBuilder<E> add(Stream<E> elements) {
        if (!MoreCollections.isEmpty(elements)) {
            elements.forEach(this::add);
        }
        return this;
    }

    public CollectionBuilder<E> sort(Comparator<? super E> comparator) {
        if (this.collector instanceof List) {
            Collections.sort((List)this.collector, comparator);
        } else {
            ArrayList<E> sorter = new ArrayList<E>(this.collector);
            Collections.sort(sorter, comparator);
            this.collector.clear();
            this.collector.addAll(sorter);
        }
        return this;
    }

    public List<E> toMutableList() {
        return new ArrayList<E>(this.collector);
    }

    public List<E> toImmutableList() {
        return Collections.unmodifiableList(this.toMutableList());
    }

    public Set<E> toMutableSet() {
        return new HashSet<E>(this.collector);
    }

    public Set<E> toImmutableSet() {
        return Collections.unmodifiableSet(this.toMutableSet());
    }

    public List<E> toConcurrentList() {
        return new CopyOnWriteArrayList<E>(this.collector);
    }

    public Set<E> toConcurrentSet() {
        return new CopyOnWriteArraySet<E>(this.collector);
    }

    public NavigableSet<E> toMutableNavigableSet() {
        return new TreeSet<E>(this.collector);
    }

    public NavigableSet<E> toImmutableNavigableSet() {
        return Collections.unmodifiableNavigableSet(this.toMutableNavigableSet());
    }

    public NavigableSet<E> toConcurrentNavigableSet() {
        return new ConcurrentSkipListSet<E>(this.collector);
    }

    public E[] toArray(Class<? super E> targetType) {
        if (this.isEmpty()) {
            return (Object[])Array.newInstance(targetType, 0);
        }
        Object[] target = (Object[])Array.newInstance(targetType, this.size());
        return this.collector.toArray(target);
    }

    public CollectionBuilder<E> clear() {
        this.collector.clear();
        return this;
    }

    public static <E> CollectionBuilder<E> copyFrom(Iterable<? extends E> source) {
        return new CollectionBuilder<E>(CollectionLiterals.mutableList(source));
    }

    public static <E> CollectionBuilder<E> copyFrom(Iterator<? extends E> source) {
        return new CollectionBuilder<E>(CollectionLiterals.mutableList(source));
    }

    public static <E> CollectionBuilder<E> copyFrom(Collection<? extends E> source) {
        return new CollectionBuilder<E>(CollectionLiterals.mutableList(source));
    }

    public static <E> CollectionBuilder<E> copyFrom(Stream<? extends E> source) {
        return new CollectionBuilder<E>(CollectionLiterals.mutableList(source));
    }

    @SafeVarargs
    public static <E> CollectionBuilder<E> copyFrom(E ... source) {
        return new CollectionBuilder<E[]>(CollectionLiterals.mutableList(source));
    }

    public static <E> CollectionBuilder<E> copyFrom(E source) {
        return new CollectionBuilder<E>(CollectionLiterals.mutableList(source));
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CollectionBuilder)) {
            return false;
        }
        CollectionBuilder other = (CollectionBuilder)o;
        if (this.isAddNullValues() != other.isAddNullValues()) {
            return false;
        }
        Collection<E> this$collector = this.collector;
        Collection<E> other$collector = other.collector;
        return !(this$collector == null ? other$collector != null : !((Object)this$collector).equals(other$collector));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAddNullValues() ? 79 : 97);
        Collection<E> $collector = this.collector;
        result = result * 59 + ($collector == null ? 43 : ((Object)$collector).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CollectionBuilder(collector=" + this.collector + ", addNullValues=" + this.isAddNullValues() + ")";
    }

    @Generated
    public boolean isAddNullValues() {
        return this.addNullValues;
    }
}

