/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.collect;

import de.cuioss.tools.collect.MapBuilder;
import de.cuioss.tools.collect.MapDifference;
import de.cuioss.tools.collect.ValueDifferenceImpl;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;

class MapDiffenceImpl<K, V>
implements MapDifference<K, V> {
    private final Map<K, V> entriesOnlyOnRight;
    private final Map<K, V> entriesOnlyOnLeft;
    private final Map<K, V> entriesInCommon;
    private final Map<K, MapDifference.ValueDifference<V>> entriesDiffering;

    @Override
    public boolean areEqual() {
        return this.entriesOnlyOnLeft.isEmpty() && this.entriesOnlyOnRight.isEmpty() && this.entriesDiffering.isEmpty();
    }

    @Override
    public Map<K, V> entriesOnlyOnLeft() {
        return this.entriesOnlyOnLeft;
    }

    @Override
    public Map<K, V> entriesOnlyOnRight() {
        return this.entriesOnlyOnRight;
    }

    @Override
    public Map<K, V> entriesInCommon() {
        return this.entriesInCommon;
    }

    @Override
    public Map<K, MapDifference.ValueDifference<V>> entriesDiffering() {
        return this.entriesDiffering;
    }

    static <K, V> MapDifference<K, V> from(Map<? extends K, ? extends V> left, Map<? extends K, ? extends V> right) {
        Objects.requireNonNull(left);
        Objects.requireNonNull(right);
        MapBuilder onlyRight = new MapBuilder();
        MapBuilder onlyLeft = new MapBuilder();
        MapBuilder common = new MapBuilder();
        MapBuilder entriesDiffering = new MapBuilder();
        MapDiffenceImpl.sortEntriesToBucket(left, right, onlyLeft, common, entriesDiffering);
        MapDiffenceImpl.sortEntriesToBucket(right, left, onlyRight, common, entriesDiffering);
        return new MapDiffenceImpl(onlyRight.toImmutableMap(), onlyLeft.toImmutableMap(), common.toImmutableMap(), entriesDiffering.toImmutableMap());
    }

    static <V, K> void sortEntriesToBucket(Map<? extends K, ? extends V> left, Map<? extends K, ? extends V> right, MapBuilder<K, V> onlyLeft, MapBuilder<K, V> common, MapBuilder<K, MapDifference.ValueDifference<V>> entriesDiffering) {
        for (Map.Entry<K, V> entry : left.entrySet()) {
            if (right.containsKey(entry.getKey())) {
                V rightValue = right.get(entry.getKey());
                V leftValue = entry.getValue();
                if (MapDiffenceImpl.checkEqualityNullsafe(leftValue, rightValue)) {
                    if (common.containsKey(entry.getKey())) continue;
                    common.put(entry);
                    continue;
                }
                if (entriesDiffering.containsKey(entry.getKey())) continue;
                entriesDiffering.put(entry.getKey(), new ValueDifferenceImpl<V>(leftValue, rightValue));
                continue;
            }
            onlyLeft.put(entry);
        }
    }

    private static boolean checkEqualityNullsafe(Object leftValue, Object rightValue) {
        if (leftValue == rightValue) {
            return true;
        }
        if (null == leftValue || null == rightValue) {
            return false;
        }
        return leftValue.equals(rightValue);
    }

    @Generated
    public MapDiffenceImpl(Map<K, V> entriesOnlyOnRight, Map<K, V> entriesOnlyOnLeft, Map<K, V> entriesInCommon, Map<K, MapDifference.ValueDifference<V>> entriesDiffering) {
        this.entriesOnlyOnRight = entriesOnlyOnRight;
        this.entriesOnlyOnLeft = entriesOnlyOnLeft;
        this.entriesInCommon = entriesInCommon;
        this.entriesDiffering = entriesDiffering;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapDiffenceImpl)) {
            return false;
        }
        MapDiffenceImpl other = (MapDiffenceImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<K, V> this$entriesOnlyOnRight = this.entriesOnlyOnRight;
        Map<K, V> other$entriesOnlyOnRight = other.entriesOnlyOnRight;
        if (this$entriesOnlyOnRight == null ? other$entriesOnlyOnRight != null : !((Object)this$entriesOnlyOnRight).equals(other$entriesOnlyOnRight)) {
            return false;
        }
        Map<K, V> this$entriesOnlyOnLeft = this.entriesOnlyOnLeft;
        Map<K, V> other$entriesOnlyOnLeft = other.entriesOnlyOnLeft;
        if (this$entriesOnlyOnLeft == null ? other$entriesOnlyOnLeft != null : !((Object)this$entriesOnlyOnLeft).equals(other$entriesOnlyOnLeft)) {
            return false;
        }
        Map<K, V> this$entriesInCommon = this.entriesInCommon;
        Map<K, V> other$entriesInCommon = other.entriesInCommon;
        if (this$entriesInCommon == null ? other$entriesInCommon != null : !((Object)this$entriesInCommon).equals(other$entriesInCommon)) {
            return false;
        }
        Map<K, MapDifference.ValueDifference<V>> this$entriesDiffering = this.entriesDiffering;
        Map<K, MapDifference.ValueDifference<V>> other$entriesDiffering = other.entriesDiffering;
        return !(this$entriesDiffering == null ? other$entriesDiffering != null : !((Object)this$entriesDiffering).equals(other$entriesDiffering));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MapDiffenceImpl;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<K, V> $entriesOnlyOnRight = this.entriesOnlyOnRight;
        result = result * 59 + ($entriesOnlyOnRight == null ? 43 : ((Object)$entriesOnlyOnRight).hashCode());
        Map<K, V> $entriesOnlyOnLeft = this.entriesOnlyOnLeft;
        result = result * 59 + ($entriesOnlyOnLeft == null ? 43 : ((Object)$entriesOnlyOnLeft).hashCode());
        Map<K, V> $entriesInCommon = this.entriesInCommon;
        result = result * 59 + ($entriesInCommon == null ? 43 : ((Object)$entriesInCommon).hashCode());
        Map<K, MapDifference.ValueDifference<V>> $entriesDiffering = this.entriesDiffering;
        result = result * 59 + ($entriesDiffering == null ? 43 : ((Object)$entriesDiffering).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MapDiffenceImpl(entriesOnlyOnRight=" + this.entriesOnlyOnRight + ", entriesOnlyOnLeft=" + this.entriesOnlyOnLeft + ", entriesInCommon=" + this.entriesInCommon + ", entriesDiffering=" + this.entriesDiffering + ")";
    }
}

