/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.formatting.template.lexer;

import de.cuioss.tools.base.Preconditions;
import de.cuioss.tools.formatting.template.FormatterSupport;
import de.cuioss.tools.formatting.template.lexer.Lexer;
import de.cuioss.tools.formatting.template.token.ActionToken;
import de.cuioss.tools.formatting.template.token.StringToken;
import de.cuioss.tools.formatting.template.token.Token;
import de.cuioss.tools.string.MoreStrings;
import de.cuioss.tools.string.Splitter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import lombok.Generated;

class BracketLexer<T extends FormatterSupport>
extends Lexer<T> {
    private static final long serialVersionUID = 6117181403355108849L;
    private static final Pattern SPACE_CLEANER_PATTERN = Pattern.compile("\\,");
    private final Brackets brackets;
    private final boolean strict;

    BracketLexer(T source, Brackets brackets) {
        this(source, brackets, false);
    }

    BracketLexer(T source, Brackets brackets, boolean strict) {
        super(source);
        this.brackets = Objects.requireNonNull(brackets, "Brackets must not be null.");
        this.strict = strict;
    }

    @Override
    public List<Token> scan(String input) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        if (!MoreStrings.isEmpty(input)) {
            List<String> chunksSplitByLeftBracket = this.brackets.splitByLeftBracket(input);
            List<String> chunksSplitByRightBracket = this.brackets.splitByRightBracket(input);
            int leftBracketCount = MoreStrings.countMatches(input, String.valueOf(this.brackets.leftBracket));
            int rightBracketCount = MoreStrings.countMatches(input, String.valueOf(this.brackets.rightBracket));
            boolean chunkCountEven = chunksSplitByLeftBracket.size() == chunksSplitByRightBracket.size();
            boolean bracketCountEven = leftBracketCount == rightBracketCount;
            Preconditions.checkArgument(chunkCountEven && bracketCountEven, "pattern '%s' is unbalanced for %s, left-hand:%s, right-hand:%s", new Object[]{input, this.brackets, chunksSplitByLeftBracket, chunksSplitByRightBracket});
            for (String chunk : chunksSplitByRightBracket) {
                if (MoreStrings.isEmpty(chunk)) continue;
                this.parseChunk(chunk, tokens);
            }
        }
        return tokens;
    }

    private void parseChunk(String chunk, List<Token> tokens) {
        String cleaned = this.disposeStringToken(chunk, tokens);
        if (!MoreStrings.isEmpty(cleaned)) {
            String token;
            boolean tokenRecognized = false;
            if (!this.strict) {
                token = BracketLexer.getBestFittingToken(cleaned, this.getTokenList());
            } else {
                String spaceCleaned = SPACE_CLEANER_PATTERN.matcher(cleaned).replaceAll("").trim();
                token = this.getTokenList().contains(spaceCleaned) ? spaceCleaned : null;
            }
            if (null != token) {
                tokens.add(new ActionToken(cleaned, token));
                tokenRecognized = true;
            }
            if (!tokenRecognized) {
                BracketLexer.throwUnsupportedTokenException(cleaned, this.getTokenList());
            }
        }
    }

    private static String getBestFittingToken(String cleanedChunk, List<String> tokens) {
        Candidate mostFittingCandidate = new Candidate(cleanedChunk, null);
        for (String token : tokens) {
            Candidate otherCandidate;
            if (MoreStrings.isEmpty(token) || !cleanedChunk.contains(token) || mostFittingCandidate.fitsMoreThan(otherCandidate = new Candidate(cleanedChunk, token))) continue;
            mostFittingCandidate = otherCandidate;
        }
        return mostFittingCandidate.getTokenName();
    }

    private String disposeStringToken(String chunk, List<Token> tokens) {
        int startPoint = chunk.indexOf(this.brackets.leftBracket);
        if (startPoint > 0) {
            String value = chunk.substring(0, startPoint);
            tokens.add(new StringToken(value));
        } else if (startPoint == -1) {
            startPoint = chunk.length() - 1;
            tokens.add(new StringToken(chunk));
        }
        return chunk.substring(startPoint + 1);
    }

    @Override
    @Generated
    public String toString() {
        return "BracketLexer(brackets=" + this.brackets + ", strict=" + this.strict + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BracketLexer)) {
            return false;
        }
        BracketLexer other = (BracketLexer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.strict != other.strict) {
            return false;
        }
        Brackets this$brackets = this.brackets;
        Brackets other$brackets = other.brackets;
        return !(this$brackets == null ? other$brackets != null : !((Object)((Object)this$brackets)).equals((Object)other$brackets));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BracketLexer;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.strict ? 79 : 97);
        Brackets $brackets = this.brackets;
        result = result * 59 + ($brackets == null ? 43 : ((Object)((Object)$brackets)).hashCode());
        return result;
    }

    private static class Candidate {
        private static final int HUGE_NUMBER = 999999;
        private final String tokenName;
        private final int fittingIndex;

        public String getTokenName() {
            return this.tokenName;
        }

        public int getFittingIndex() {
            return this.fittingIndex;
        }

        public Candidate(String cleanedChunk, String tokenName) {
            if (null != tokenName) {
                this.tokenName = tokenName;
                int difference = cleanedChunk.compareTo(tokenName);
                if (0 > difference) {
                    difference *= -1;
                }
                this.fittingIndex = difference;
            } else {
                this.tokenName = null;
                this.fittingIndex = 999999;
            }
        }

        public boolean fitsMoreThan(Candidate otherCandidate) {
            return this.fittingIndex < otherCandidate.getFittingIndex();
        }
    }

    static enum Brackets {
        SQUARED_BRACKETS('[', ']'),
        CURLY_BRACKETS('{', '}'),
        ANGLE_BRACKET('<', '>');

        final char leftBracket;
        final char rightBracket;

        private Brackets(char left, char right) {
            this.leftBracket = left;
            this.rightBracket = right;
        }

        List<String> splitByLeftBracket(String input) {
            return Splitter.on(this.leftBracket).omitEmptyStrings().splitToList(input);
        }

        List<String> splitByRightBracket(String input) {
            return Splitter.on(this.rightBracket).omitEmptyStrings().splitToList(input);
        }

        public String toString() {
            return "BracketLexer for " + this.leftBracket + this.rightBracket;
        }
    }
}

