/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.formatting.template.lexer;

import de.cuioss.tools.base.Preconditions;
import de.cuioss.tools.collect.CollectionLiterals;
import de.cuioss.tools.formatting.template.FormatterSupport;
import de.cuioss.tools.formatting.template.token.Token;
import de.cuioss.tools.string.MoreStrings;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

public abstract class Lexer<T extends FormatterSupport>
implements Serializable {
    private static final long serialVersionUID = 8645233576605974741L;
    private final List<String> tokenList;

    protected Lexer(T source) {
        Objects.requireNonNull(source, "Source must not be null");
        this.tokenList = CollectionLiterals.immutableList((Collection)Objects.requireNonNull(source.getSupportedPropertyNames()));
        for (String attribute : this.tokenList) {
            Preconditions.checkArgument(!MoreStrings.isEmpty(attribute), "Attributes must not be null or empty. '" + this.tokenList + "'");
        }
    }

    protected static final void throwUnsupportedTokenException(String wrongToken, List<String> allowedTokens) {
        StringBuilder builder = new StringBuilder();
        builder.append("Unsupported token '").append(wrongToken).append("' was detected.\n").append("Allowed are :\n");
        for (String allowedToken : allowedTokens) {
            builder.append(" - ").append(allowedToken).append("\n");
        }
        throw new IllegalArgumentException(builder.toString());
    }

    public abstract List<Token> scan(String var1);

    public final void validateTemplate(String input) {
        this.scan(input);
    }

    @Generated
    public String toString() {
        return "Lexer(tokenList=" + this.getTokenList() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Lexer)) {
            return false;
        }
        Lexer other = (Lexer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$tokenList = this.getTokenList();
        List<String> other$tokenList = other.getTokenList();
        return !(this$tokenList == null ? other$tokenList != null : !((Object)this$tokenList).equals(other$tokenList));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Lexer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $tokenList = this.getTokenList();
        result = result * 59 + ($tokenList == null ? 43 : ((Object)$tokenList).hashCode());
        return result;
    }

    @Generated
    protected List<String> getTokenList() {
        return this.tokenList;
    }

    public static enum ExpressionLanguage {
        SIMPLE_SQUARED_BRACKTES,
        SIMPLE_CURLY_BRACKETS,
        SIMPLE_ANGLE_BRACKET,
        STEL;

    }
}

