/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.io;

import de.cuioss.tools.base.Preconditions;
import de.cuioss.tools.io.ClassPathLoader;
import de.cuioss.tools.io.FileLoader;
import de.cuioss.tools.io.FileSystemLoader;
import de.cuioss.tools.io.FileTypePrefix;
import de.cuioss.tools.io.IOStreams;
import de.cuioss.tools.io.UrlLoader;
import de.cuioss.tools.string.MoreStrings;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import lombok.Generated;

public final class FileLoaderUtility {
    public static FileLoader getLoaderForPath(String pathName) {
        if (MoreStrings.isEmpty(pathName)) {
            throw new IllegalArgumentException("pathName must not be null nor empty");
        }
        if (pathName.startsWith(FileTypePrefix.CLASSPATH.getPrefix())) {
            return new ClassPathLoader(pathName);
        }
        if (pathName.startsWith(FileTypePrefix.URL.getPrefix())) {
            return new UrlLoader(pathName);
        }
        return new FileSystemLoader(pathName);
    }

    public static Path copyFileToTemp(FileLoader source, boolean markDeleteOnExit) throws IOException {
        Preconditions.checkArgument(null != source, "Attribute with name source must not be null");
        Preconditions.checkArgument(source.isReadable(), "Source must be readable");
        Path target = Files.createTempFile(source.getFileName().getNamePart(), source.getFileName().getSuffix(), new FileAttribute[0]);
        try (InputStream inputStream = source.inputStream();){
            Files.copy(new BufferedInputStream(inputStream), target, StandardCopyOption.REPLACE_EXISTING);
        }
        if (markDeleteOnExit) {
            target.toFile().deleteOnExit();
        }
        return target;
    }

    public static String toString(FileLoader fileLoader, Charset charset) throws IOException {
        Objects.requireNonNull(fileLoader);
        StringWriter writer = new StringWriter();
        try (InputStream inputStream = fileLoader.inputStream();){
            IOStreams.copy(inputStream, (Writer)writer, charset);
        }
        return writer.toString();
    }

    public static String toString(FileLoader fileLoader) throws IOException {
        return FileLoaderUtility.toString(fileLoader, StandardCharsets.UTF_8);
    }

    public static String toStringUnchecked(FileLoader fileLoader) {
        Objects.requireNonNull(fileLoader);
        try {
            return FileLoaderUtility.toString(fileLoader);
        }
        catch (IOException | IllegalStateException e) {
            throw new IllegalArgumentException("Unable to read from Path " + fileLoader.getFileName(), e);
        }
    }

    @Generated
    private FileLoaderUtility() {
    }
}

