/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.io;

import de.cuioss.tools.base.Preconditions;
import de.cuioss.tools.io.FileLoader;
import de.cuioss.tools.io.FileTypePrefix;
import de.cuioss.tools.io.StructuredFilename;
import de.cuioss.tools.logging.CuiLogger;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public class UrlLoader
implements FileLoader {
    private static final long serialVersionUID = -8758614099334823819L;
    private static final CuiLogger log = new CuiLogger(UrlLoader.class);
    private final URL url;
    private transient URLConnection connection;

    public UrlLoader(String url) {
        String sanitizedUrl = url;
        if (FileTypePrefix.URL.is(url)) {
            sanitizedUrl = FileTypePrefix.URL.removePrefix(url);
        }
        try {
            this.url = new URL(sanitizedUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Provided URL is invalid: " + url, e);
        }
    }

    public UrlLoader(URL url) {
        Preconditions.checkArgument(null != url, "url must not be null");
        this.url = url;
    }

    @Override
    public boolean isReadable() {
        try {
            Optional<URLConnection> con = this.getConnection();
            if (con.isPresent()) {
                con.get().connect();
                return true;
            }
        }
        catch (IOException e) {
            log.error(e, "Could not read from URL: {}", this.getURL());
        }
        return false;
    }

    @Override
    public StructuredFilename getFileName() {
        return new StructuredFilename(this.getURL().getPath());
    }

    @Override
    public InputStream inputStream() throws IOException {
        Optional<URLConnection> con = this.getConnection();
        if (con.isPresent()) {
            return con.get().getInputStream();
        }
        return null;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public boolean isFilesystemLoader() {
        return false;
    }

    private Optional<URLConnection> getConnection() {
        if (null == this.connection) {
            try {
                this.connection = this.url.openConnection();
                this.connection.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(5L));
                this.connection.setReadTimeout((int)TimeUnit.SECONDS.toMillis(5L));
            }
            catch (IOException e) {
                log.error(e, "Portal-538: Could not read from URL: {}", this.getURL());
            }
        }
        return Optional.ofNullable(this.connection);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UrlLoader)) {
            return false;
        }
        UrlLoader other = (UrlLoader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        URL this$url = this.getURL();
        URL other$url = other.getURL();
        return !(this$url == null ? other$url != null : !((Object)this$url).equals(other$url));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UrlLoader;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URL $url = this.getURL();
        result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "UrlLoader(url=" + this.getURL() + ")";
    }
}

