/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.lang;

import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.string.MoreStrings;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;

public final class SecuritySupport {
    private static final String SECURITY_MANAGER_CONFIGURED = "A SecurityManager is configured, using PrivilegedAction";
    private static final CuiLogger LOGGER = new CuiLogger(SecuritySupport.class);

    public static Optional<ClassLoader> getContextClassLoader() {
        if (null == System.getSecurityManager()) {
            LOGGER.trace("No SecurityManager configured, accessing context-class-loader");
            return Optional.ofNullable(Thread.currentThread().getContextClassLoader());
        }
        LOGGER.trace(SECURITY_MANAGER_CONFIGURED);
        return AccessController.doPrivileged(() -> {
            try {
                return Optional.ofNullable(Thread.currentThread().getContextClassLoader());
            }
            catch (SecurityException e) {
                LOGGER.warn("Unable to access context-class-loader due to SecurityException", e);
                return Optional.empty();
            }
        });
    }

    public static void setAccessible(AccessibleObject object, boolean accessible) {
        if (null == System.getSecurityManager()) {
            LOGGER.trace("No SecurityManager configured, setting accessible directly");
            object.setAccessible(accessible);
        } else {
            LOGGER.trace(SECURITY_MANAGER_CONFIGURED);
            AccessController.doPrivileged(() -> {
                try {
                    object.setAccessible(accessible);
                }
                catch (SecurityException e) {
                    LOGGER.warn("Unable to call 'setAccessible' due to SecurityException", e);
                }
                return null;
            });
        }
    }

    public static Optional<String> accessSystemProperty(String propertyName) {
        if (MoreStrings.isEmpty(propertyName)) {
            return Optional.empty();
        }
        if (null == System.getSecurityManager()) {
            LOGGER.trace("No SecurityManager configured, accessing System-Property directly");
            return Optional.ofNullable(System.getProperty(propertyName));
        }
        LOGGER.trace(SECURITY_MANAGER_CONFIGURED);
        return AccessController.doPrivileged(() -> {
            try {
                return Optional.ofNullable(System.getProperty(propertyName));
            }
            catch (SecurityException e) {
                LOGGER.warn("Unable to call 'System.getProperty' due to SecurityException", e);
                return Optional.empty();
            }
        });
    }

    public static Properties accessSystemProperties() {
        if (null == System.getSecurityManager()) {
            LOGGER.trace("No SecurityManager configured, accessing System.getProperties directly");
            return System.getProperties();
        }
        LOGGER.trace(SECURITY_MANAGER_CONFIGURED);
        return AccessController.doPrivileged(() -> {
            try {
                return System.getProperties();
            }
            catch (SecurityException e) {
                LOGGER.warn("Unable to call 'System.getProperties' due to SecurityException", e);
                return new Properties();
            }
        });
    }

    public static Map<String, String> accessSystemEnv() {
        if (null == System.getSecurityManager()) {
            LOGGER.trace("No SecurityManager configured, accessing System.getenv directly");
            return System.getenv();
        }
        LOGGER.trace(SECURITY_MANAGER_CONFIGURED);
        return AccessController.doPrivileged(() -> {
            try {
                return System.getenv();
            }
            catch (SecurityException e) {
                LOGGER.warn("Unable to call 'System.getenv' due to SecurityException", e);
                return Collections.emptyMap();
            }
        });
    }

    public static <T> Constructor<? extends T> getDeclaredConstructor(Class<T> clazz, Class<?> ... paramTypes) throws NoSuchMethodException {
        if (null == System.getSecurityManager()) {
            LOGGER.trace("No SecurityManager configured, accessing declared constructors directly");
            return clazz.getDeclaredConstructor(paramTypes);
        }
        try {
            LOGGER.trace(SECURITY_MANAGER_CONFIGURED);
            return AccessController.doPrivileged(() -> {
                Constructor constructor = null;
                try {
                    constructor = clazz.getDeclaredConstructor(paramTypes);
                }
                catch (SecurityException e) {
                    LOGGER.warn(e, "Unable to call 'getDeclaredConstructor' due to SecurityException, class='{}', paramTypes='{}'", clazz.toString(), Arrays.toString(paramTypes));
                }
                return constructor;
            });
        }
        catch (PrivilegedActionException e) {
            Exception e2 = e.getException();
            if (e2 instanceof NoSuchMethodException) {
                throw (NoSuchMethodException)e2;
            }
            throw new IllegalStateException(e2);
        }
    }

    @Generated
    private SecuritySupport() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

