/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.property;

import de.cuioss.tools.base.Preconditions;
import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.reflect.MoreReflection;
import de.cuioss.tools.string.MoreStrings;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public final class PropertyUtil {
    private static final CuiLogger log = new CuiLogger(PropertyUtil.class);
    static final String UNABLE_TO_WRITE_PROPERTY = "Unable to write property '%s' to beanType '%s': no suitable write method found. Needed property-type '%s'";
    static final String UNABLE_TO_WRITE_PROPERTY_RUNTIME = "Unable to write property '%s' to beanType '%s'. Needed property-type '%s'";
    static final String UNABLE_TO_READ_PROPERTY = "Unable to read property '%s' from beanType '%s'.";

    public static Object readProperty(Object bean, String propertyName) {
        log.debug("Reading property '%s' from %s", propertyName, bean);
        Objects.requireNonNull(bean);
        MoreStrings.requireNotEmptyTrimmed(propertyName);
        Optional<Method> reader = MoreReflection.retrieveAccessMethod(bean.getClass(), propertyName);
        Preconditions.checkArgument(reader.isPresent(), UNABLE_TO_READ_PROPERTY, propertyName, bean.getClass());
        try {
            return reader.get().invoke(bean, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalStateException(MoreStrings.lenientFormat(UNABLE_TO_READ_PROPERTY, propertyName, bean.getClass()), e);
        }
    }

    public static Object writeProperty(Object bean, String propertyName, Object propertyValue) {
        log.debug("Writing '%s' to property '%s' on '%s'", propertyValue, propertyName, bean);
        Objects.requireNonNull(bean);
        MoreStrings.requireNotEmptyTrimmed(propertyName);
        Method writeMethod = PropertyUtil.determineWriteMethod(bean, propertyName, propertyValue);
        try {
            Object result = writeMethod.invoke(bean, propertyValue);
            return Objects.requireNonNullElse(result, bean);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            String target = propertyValue != null ? propertyValue.getClass().getName() : "Undefined";
            throw new IllegalStateException(MoreStrings.lenientFormat(UNABLE_TO_WRITE_PROPERTY_RUNTIME, propertyName, bean.getClass(), target), e);
        }
    }

    public static Optional<Class<?>> resolvePropertyType(Class<?> beanType, String propertyName) {
        Optional<Method> retrieveAccessMethod = MoreReflection.retrieveAccessMethod(beanType, propertyName);
        if (retrieveAccessMethod.isPresent()) {
            log.trace("Found read-method on class '%s' for property-name '%s'", beanType, propertyName);
            return Optional.of(retrieveAccessMethod.get().getReturnType());
        }
        Optional<Field> field = MoreReflection.accessField(beanType, propertyName);
        if (field.isPresent()) {
            log.trace("Found field on class '%s' with name '%s'", beanType, propertyName);
            return Optional.of(field.get().getType());
        }
        log.debug("Neither read-method nor field found on class '%s' for property-name '%s', checking write methods, returning first type found", beanType, propertyName);
        Collection<Method> candidates = MoreReflection.retrieveWriteMethodCandidates(beanType, propertyName);
        if (!candidates.isEmpty()) {
            return Optional.of(candidates.iterator().next().getParameterTypes()[0]);
        }
        log.debug("Unable to detect property-type on class '%s' for property-name '%s'", beanType, propertyName);
        return Optional.empty();
    }

    static Method determineWriteMethod(Object bean, String propertyName, Object propertyValue) {
        Collection<Method> candidates = MoreReflection.retrieveWriteMethodCandidates(bean.getClass(), propertyName);
        String target = propertyValue != null ? propertyValue.getClass().getName() : "Undefined";
        Preconditions.checkArgument(!candidates.isEmpty(), UNABLE_TO_WRITE_PROPERTY, propertyName, bean.getClass(), target);
        if (null == propertyValue) {
            log.trace("No / Null propertyValue given, so any method should suffice to write property '%s' to %s", propertyName, bean);
            return candidates.iterator().next();
        }
        for (Method candidate : candidates) {
            if (!MoreReflection.checkWhetherParameterIsAssignable(candidate.getParameterTypes()[0], propertyValue.getClass())) continue;
            log.trace("Found method %s to write property '%s' to %s", candidate, propertyName, bean);
            return candidate;
        }
        throw new IllegalArgumentException(MoreStrings.lenientFormat(UNABLE_TO_WRITE_PROPERTY, propertyName, bean.getClass(), target));
    }

    @Generated
    private PropertyUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

