/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.reflect;

import de.cuioss.tools.lang.SecuritySupport;
import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.reflect.MoreReflection;
import de.cuioss.tools.string.MoreStrings;
import java.lang.reflect.Field;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public class FieldWrapper {
    private static final CuiLogger log = new CuiLogger(FieldWrapper.class);
    @NonNull
    private final Field field;
    private final Class<?> declaringClass;

    public FieldWrapper(Field field) {
        this.field = field;
        this.declaringClass = field.getDeclaringClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Object> readValue(Object object) {
        if (null == object) {
            log.trace("No Object given, returning Optional#empty()");
            return Optional.empty();
        }
        if (!this.declaringClass.isAssignableFrom(object.getClass())) {
            log.trace("Given Object is improper type, returning Optional#empty()");
            return Optional.empty();
        }
        boolean initialAccessible = this.field.canAccess(object);
        log.trace("Reading from field '{}' with accessibleFlag='{}' ", this.field, initialAccessible);
        Field field = this.field;
        synchronized (field) {
            Optional<Object> optional;
            block13: {
                if (!initialAccessible) {
                    log.trace("Explicitly setting accessible flag");
                    SecuritySupport.setAccessible(this.field, true);
                }
                try {
                    optional = Optional.ofNullable(this.field.get(object));
                    if (initialAccessible) break block13;
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    Optional<Object> optional2;
                    block14: {
                        try {
                            log.warn(e, "Reading from field '{}' with accessible='{}' and parameter ='{}' could not complete", this.field, initialAccessible, object);
                            optional2 = Optional.empty();
                            if (initialAccessible) break block14;
                            log.trace("Resetting accessible flag");
                        }
                        catch (Throwable throwable) {
                            if (!initialAccessible) {
                                log.trace("Resetting accessible flag");
                                SecuritySupport.setAccessible(this.field, false);
                            }
                            throw throwable;
                        }
                        SecuritySupport.setAccessible(this.field, false);
                    }
                    return optional2;
                }
                log.trace("Resetting accessible flag");
                SecuritySupport.setAccessible(this.field, false);
            }
            return optional;
        }
    }

    public static final Optional<Object> readValue(String fieldName, Object object) {
        Optional<FieldWrapper> fieldProvider = FieldWrapper.from(object.getClass(), fieldName);
        log.trace("FieldWrapper: {}", fieldProvider);
        if (fieldProvider.isPresent()) {
            FieldWrapper fieldWrapper = fieldProvider.get();
            return fieldWrapper.readValue(object);
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeValue(@NonNull Object object, Object value) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        boolean initialAccessible = this.field.canAccess(object);
        log.trace("Writing to field '{}' with accessibleFlag='{}' ", this.field, initialAccessible);
        Field field = this.field;
        synchronized (field) {
            if (!initialAccessible) {
                log.trace("Explicitly setting accessible flag");
                SecuritySupport.setAccessible(this.field, true);
            }
            try {
                this.field.set(object, value);
            }
            catch (IllegalAccessException e) {
                String message = MoreStrings.lenientFormat("Writing to field '{}' with accessible='{}' and parameter ='{}' could not complete", this.field, initialAccessible, object);
                throw new IllegalStateException(message, e);
            }
            finally {
                if (!initialAccessible) {
                    log.trace("Resetting accessible flag");
                    SecuritySupport.setAccessible(this.field, false);
                }
            }
        }
    }

    public static final Optional<FieldWrapper> from(Class<?> type, String fieldName) {
        Optional<Field> loaded = MoreReflection.accessField(type, fieldName);
        if (loaded.isPresent()) {
            return Optional.of(new FieldWrapper(loaded.get()));
        }
        return Optional.empty();
    }

    @NonNull
    @Generated
    public Field getField() {
        return this.field;
    }
}

