/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.string;

import de.cuioss.tools.base.Preconditions;
import de.cuioss.tools.logging.CuiLogger;
import java.util.Optional;
import java.util.function.Predicate;
import lombok.Generated;
import lombok.NonNull;

public final class MoreStrings {
    private static final CuiLogger log = new CuiLogger(MoreStrings.class);
    public static final String EMPTY = "";
    private static final int PAD_LIMIT = 8192;
    public static final String SPACE = " ";
    public static final int INDEX_NOT_FOUND = -1;

    public static String unquote(String original) {
        if (MoreStrings.isEmpty(original)) {
            return original;
        }
        if (original.startsWith("\"") && original.endsWith("\"") || original.startsWith("'") && original.endsWith("'")) {
            return original.substring(1, original.length() - 1);
        }
        return original;
    }

    public static boolean isAllLowerCase(CharSequence cs) {
        if (MoreStrings.isEmpty(cs)) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isLowerCase(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllUpperCase(CharSequence cs) {
        if (MoreStrings.isEmpty(cs)) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isUpperCase(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isPresent(CharSequence cs) {
        return cs != null && cs.length() > 0;
    }

    public static boolean isNumeric(CharSequence cs) {
        if (MoreStrings.isEmpty(cs)) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !MoreStrings.isBlank(cs);
    }

    public static int countMatches(CharSequence str, CharSequence sub) {
        if (MoreStrings.isEmpty(str) || MoreStrings.isEmpty(sub)) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        while ((idx = MoreStrings.indexOf(str, sub, idx)) != -1) {
            ++count;
            idx += sub.length();
        }
        return count;
    }

    public static String leftPad(String str, int size) {
        return MoreStrings.leftPad(str, size, ' ');
    }

    public static String leftPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return MoreStrings.leftPad(str, size, String.valueOf(padChar));
        }
        return MoreStrings.repeat(padChar, pads).concat(str);
    }

    public static String leftPad(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (MoreStrings.isEmpty(padStr)) {
            padStr = SPACE;
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return MoreStrings.leftPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return padStr.concat(str);
        }
        if (pads < padLen) {
            return padStr.substring(0, pads).concat(str);
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return new String(padding).concat(str);
    }

    public static String repeat(char ch, int repeat) {
        if (repeat <= 0) {
            return EMPTY;
        }
        char[] buf = new char[repeat];
        for (int i = repeat - 1; i >= 0; --i) {
            buf[i] = ch;
        }
        return new String(buf);
    }

    public static String stripEnd(String str, String stripChars) {
        int end;
        if (str == null || (end = str.length()) == 0) {
            return str;
        }
        if (stripChars == null) {
            while (end != 0 && Character.isWhitespace(str.charAt(end - 1))) {
                --end;
            }
        } else {
            if (stripChars.isEmpty()) {
                return str;
            }
            while (end != 0 && stripChars.indexOf(str.charAt(end - 1)) != -1) {
                --end;
            }
        }
        return str.substring(0, end);
    }

    public static int indexOf(CharSequence seq, int searchChar) {
        if (MoreStrings.isEmpty(seq)) {
            return -1;
        }
        return MoreStrings.indexOf(seq, searchChar, 0);
    }

    public static int indexOf(CharSequence cs, int searchChar, int start) {
        if (MoreStrings.isEmpty(cs)) {
            return -1;
        }
        if (cs instanceof String) {
            return ((String)cs).indexOf(searchChar, start);
        }
        int sz = cs.length();
        if (start < 0) {
            start = 0;
        }
        if (searchChar < 65536) {
            for (int i = start; i < sz; ++i) {
                if (cs.charAt(i) != searchChar) continue;
                return i;
            }
        }
        if (searchChar <= 0x10FFFF) {
            char[] chars = Character.toChars(searchChar);
            for (int i = start; i < sz - 1; ++i) {
                char high = cs.charAt(i);
                char low = cs.charAt(i + 1);
                if (high != chars[0] || low != chars[1]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(CharSequence cs, CharSequence searchChar, int start) {
        if (cs == null || searchChar == null) {
            return -1;
        }
        return cs.toString().indexOf(searchChar.toString(), start);
    }

    public static boolean hasNonWhitespaceChar(CharSequence str) {
        if (MoreStrings.isEmpty(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String requireNotEmpty(String underCheck) {
        Preconditions.checkArgument(!MoreStrings.isEmpty(underCheck), "Given String is Empty");
        return underCheck;
    }

    public static String requireNotEmpty(String underCheck, String attributeName) {
        Preconditions.checkArgument(!MoreStrings.isEmpty(underCheck), "Attribute with name '" + attributeName + "' must not be empty");
        return underCheck;
    }

    public static String requireNotEmptyTrimmed(String underCheck) {
        Preconditions.checkArgument(!MoreStrings.isBlank(underCheck), "Attribute must not be blank");
        return underCheck;
    }

    public static String requireNotEmptyTrimmed(String underCheck, String attributeName) {
        Preconditions.checkArgument(!MoreStrings.isBlank(underCheck), "Attribute with name '" + attributeName + "' must not be blank");
        return underCheck;
    }

    public static String nullToEmpty(String string) {
        if (null == string) {
            return EMPTY;
        }
        return string;
    }

    public static String emptyToNull(String string) {
        if (null == string || string.isEmpty()) {
            return null;
        }
        return string;
    }

    public static String trimOrNull(String string) {
        return null != string ? string.trim() : null;
    }

    public static String lenientFormat(String template, Object ... args) {
        int placeholderStart;
        int i;
        template = String.valueOf(template);
        if (args == null) {
            args = new Object[]{"(Object[])null"};
        } else {
            for (int i2 = 0; i2 < args.length; ++i2) {
                args[i2] = MoreStrings.lenientToString(args[i2]);
            }
        }
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        for (i = 0; i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1; ++i) {
            builder.append(template, templateStart, placeholderStart);
            builder.append(args[i]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template, templateStart, template.length());
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i]);
            ++i;
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i]);
                ++i;
            }
            builder.append(']');
        }
        return builder.toString();
    }

    public static String ensureEndsWith(@NonNull String value, @NonNull String suffix) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (suffix == null) {
            throw new NullPointerException("suffix is marked non-null but is null");
        }
        if (!value.endsWith(suffix)) {
            return value + suffix;
        }
        return value;
    }

    static String lenientToString(Object o) {
        try {
            return String.valueOf(o);
        }
        catch (Exception e) {
            String objectToString = o.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(o));
            log.warn(e, "Exception during lenientFormat for {}", objectToString);
            return "<" + objectToString + " threw " + e.getClass().getName() + ">";
        }
    }

    public static Optional<String> coalesce(Predicate<String> checker, String ... values) {
        if (null != values) {
            for (String value : values) {
                if (checker.test(value)) continue;
                return Optional.of(value);
            }
        }
        return Optional.empty();
    }

    public static Optional<String> firstNonEmpty(String ... values) {
        return MoreStrings.coalesce(MoreStrings::isEmpty, values);
    }

    public static Optional<String> firstNonBlank(String ... values) {
        return MoreStrings.coalesce(MoreStrings::isBlank, values);
    }

    @Generated
    private MoreStrings() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

