/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.string;

import de.cuioss.tools.collect.MapBuilder;
import de.cuioss.tools.string.Joiner;
import de.cuioss.tools.string.MoreStrings;
import de.cuioss.tools.string.Splitter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public class TextSplitter
implements Serializable {
    private static final long serialVersionUID = 6594890288982910944L;
    private static final String ZERO_WIDTH_SPACE = "\u200b";
    private static final String TRADE_STR = "...";
    private static final int DEFAULT_FORCE_LENGTH_BREAK = 15;
    private static final int DEFAULT_ABRIDGED_LENGTH = 20;
    private static final Map<Pattern, String> REPLACEMENT_MAP = new MapBuilder<Pattern, String>().put(Pattern.compile("#"), "#\u200b").put(Pattern.compile("\\+"), "+\u200b").put(Pattern.compile("-"), "-\u200b").put(Pattern.compile("_"), "_\u200b").put(Pattern.compile("\\."), ".\u200b").put(Pattern.compile("\\?"), "?\u200b").put(Pattern.compile("!"), "!\u200b").put(Pattern.compile(":"), ":\u200b").put(Pattern.compile(","), ",\u200b").put(Pattern.compile(";"), ";\u200b").toImmutableMap();
    private final String source;
    private final AtomicReference<Object> abridgedText = new AtomicReference();
    private boolean abridged = false;
    private final AtomicReference<Object> textWithEnforcedLineBreaks = new AtomicReference();
    private Integer forceLengthBreak = null;
    private Integer abridgedLength = null;

    public TextSplitter(String longString) {
        this.source = MoreStrings.nullToEmpty(longString);
    }

    public TextSplitter(String source, int forceLengthBreakCount, int abridgedLengthCount) {
        this.source = source;
        this.forceLengthBreak = forceLengthBreakCount;
        this.abridgedLength = abridgedLengthCount;
    }

    private int getForceLengthBreak() {
        if (null == this.forceLengthBreak) {
            return 15;
        }
        return this.forceLengthBreak;
    }

    private int getAbridgedLength() {
        if (null == this.abridgedLength) {
            return 20;
        }
        return this.abridgedLength;
    }

    private String initAbridged() {
        String result = "";
        if (!MoreStrings.isEmpty(this.source)) {
            List<String> sourceSplitted = this.getSourceSplitted();
            result = sourceSplitted.size() == 1 ? this.abridgeComputerProducedText() : this.abridgeHumanProducedText(sourceSplitted);
        }
        this.abridged = TextSplitter.endsWith(result, TRADE_STR);
        return result.trim();
    }

    private static boolean endsWith(String str, String suffix) {
        return str.trim().endsWith(suffix);
    }

    private String abridgeComputerProducedText() {
        int maxLength = this.getAbridgedLength() - (TRADE_STR.length() + 1);
        if (this.source.length() > maxLength) {
            return this.source.substring(0, maxLength) + " ...";
        }
        return this.source;
    }

    private String abridgeHumanProducedText(List<String> sourceSplitted) {
        int maxLength = this.getAbridgedLength() - TRADE_STR.length();
        StringBuilder builder = new StringBuilder();
        int count = 0;
        for (String part : sourceSplitted) {
            if ((count += part.length()) >= maxLength) {
                builder.append(TRADE_STR);
                break;
            }
            builder.append(part).append(" ");
            ++count;
        }
        return builder.toString();
    }

    private String initTextWithLineBreaks() {
        String result = "";
        if (!MoreStrings.isEmpty(this.source)) {
            List<String> sourceSplitted = this.getSourceSplitted();
            result = sourceSplitted.size() == 1 ? this.forceLineBreakForComputerProducedText(this.source) : this.forceLineBreakForHumanProducedText(sourceSplitted);
        }
        return result.trim();
    }

    private String forceLineBreakForHumanProducedText(List<String> sourceSplitted) {
        StringBuilder builder = new StringBuilder();
        for (String text : sourceSplitted) {
            builder.append(this.forceLineBreakForComputerProducedText(text)).append(" ");
        }
        return builder.toString();
    }

    private String forceLineBreakForComputerProducedText(String text) {
        String clean = text;
        for (Map.Entry<Pattern, String> entry : REPLACEMENT_MAP.entrySet()) {
            Matcher matcher = entry.getKey().matcher(clean);
            clean = matcher.replaceAll(entry.getValue());
        }
        List<String> splittedByZeroWidthSpace = TextSplitter.getSplittedByZeroWidthSpace(clean);
        ArrayList<String> lengthTrimed = new ArrayList<String>();
        for (String item : splittedByZeroWidthSpace) {
            lengthTrimed.add(this.bruteForceSplit(item));
        }
        return Joiner.on(ZERO_WIDTH_SPACE).join(lengthTrimed);
    }

    private String bruteForceSplit(String text) {
        int maxLength = this.getForceLengthBreak();
        if (!MoreStrings.isEmpty(text)) {
            StringBuilder builder = new StringBuilder();
            String tmp = text;
            while (tmp.length() > maxLength) {
                builder.append(tmp, 0, maxLength).append(ZERO_WIDTH_SPACE);
                tmp = tmp.substring(maxLength);
            }
            if (tmp.length() > 0) {
                builder.append(tmp);
            }
            return builder.toString();
        }
        return text;
    }

    private static List<String> getSplittedByZeroWidthSpace(String value) {
        return Splitter.on(ZERO_WIDTH_SPACE).splitToList(value);
    }

    private List<String> getSourceSplitted() {
        return Splitter.on(" ").splitToList(this.source);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextSplitter)) {
            return false;
        }
        TextSplitter other = (TextSplitter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getForceLengthBreak() != other.getForceLengthBreak()) {
            return false;
        }
        if (this.getAbridgedLength() != other.getAbridgedLength()) {
            return false;
        }
        String this$source = this.source;
        String other$source = other.source;
        return !(this$source == null ? other$source != null : !this$source.equals(other$source));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TextSplitter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getForceLengthBreak();
        result = result * 59 + this.getAbridgedLength();
        String $source = this.source;
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TextSplitter(source=" + this.source + ", forceLengthBreak=" + this.getForceLengthBreak() + ", abridgedLength=" + this.getAbridgedLength() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public String getAbridgedText() {
        Object value = this.abridgedText.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.abridgedText;
            synchronized (atomicReference) {
                value = this.abridgedText.get();
                if (value == null) {
                    String actualValue = this.initAbridged();
                    value = actualValue == null ? this.abridgedText : actualValue;
                    this.abridgedText.set(value);
                }
            }
        }
        return (String)(value == this.abridgedText ? null : value);
    }

    @Generated
    public boolean isAbridged() {
        return this.abridged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public String getTextWithEnforcedLineBreaks() {
        Object value = this.textWithEnforcedLineBreaks.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.textWithEnforcedLineBreaks;
            synchronized (atomicReference) {
                value = this.textWithEnforcedLineBreaks.get();
                if (value == null) {
                    String actualValue = this.initTextWithLineBreaks();
                    value = actualValue == null ? this.textWithEnforcedLineBreaks : actualValue;
                    this.textWithEnforcedLineBreaks.set(value);
                }
            }
        }
        return (String)(value == this.textWithEnforcedLineBreaks ? null : value);
    }

    @Generated
    public void setForceLengthBreak(Integer forceLengthBreak) {
        this.forceLengthBreak = forceLengthBreak;
    }

    @Generated
    public void setAbridgedLength(Integer abridgedLength) {
        this.abridgedLength = abridgedLength;
    }
}

