/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.formatting.template.lexer;

import de.cuioss.tools.formatting.template.FormatterSupport;
import de.cuioss.tools.formatting.template.lexer.BracketLexer;
import de.cuioss.tools.formatting.template.lexer.Lexer;
import java.lang.reflect.InvocationTargetException;
import java.util.EnumSet;
import java.util.Objects;
import lombok.Generated;

public final class LexerBuilder {
    static final EnumSet<Lexer.ExpressionLanguage> SIMPLE = EnumSet.of(Lexer.ExpressionLanguage.SIMPLE_SQUARED_BRACKTES, Lexer.ExpressionLanguage.SIMPLE_CURLY_BRACKETS, Lexer.ExpressionLanguage.SIMPLE_ANGLE_BRACKET);

    public static Builder useSimpleElWithSquaredBrackets() {
        return new Builder(Lexer.ExpressionLanguage.SIMPLE_SQUARED_BRACKTES);
    }

    public static Builder withExpressionLanguage(Lexer.ExpressionLanguage expLanguage) {
        Objects.requireNonNull(expLanguage, "ExpressionLanguage must not be null.");
        return new Builder(expLanguage);
    }

    @Generated
    private LexerBuilder() {
    }

    public static final class Builder {
        private final Lexer.ExpressionLanguage expl;
        private boolean strict = false;

        private Builder(Lexer.ExpressionLanguage expLanguage) {
            this.expl = expLanguage;
        }

        private static BracketLexer.Brackets getBracketsTypeFor(Lexer.ExpressionLanguage expl) {
            return switch (expl) {
                case Lexer.ExpressionLanguage.SIMPLE_SQUARED_BRACKTES -> BracketLexer.Brackets.SQUARED_BRACKETS;
                case Lexer.ExpressionLanguage.SIMPLE_CURLY_BRACKETS -> BracketLexer.Brackets.CURLY_BRACKETS;
                case Lexer.ExpressionLanguage.SIMPLE_ANGLE_BRACKET -> BracketLexer.Brackets.ANGLE_BRACKET;
                default -> throw new IllegalArgumentException(expl + " doesn't belongs to Simple expression language.");
            };
        }

        public Builder strict(boolean strict) {
            this.strict = strict;
            return this;
        }

        public <F extends FormatterSupport> Lexer<F> build(F source) {
            if (SIMPLE.contains((Object)this.expl)) {
                return new BracketLexer<F>(source, Builder.getBracketsTypeFor(this.expl), this.strict);
            }
            throw new IllegalArgumentException(this.expl + " doesn't belongs to Simple expression language.");
        }

        public <F extends FormatterSupport> Lexer<F> build(Class<F> sourceType) {
            try {
                return this.build((FormatterSupport)sourceType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | RuntimeException | InvocationTargetException e) {
                throw new IllegalStateException("Class '" + sourceType + "' should provide an accessible default constructor.", e);
            }
        }
    }
}

