/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.io;

import de.cuioss.tools.base.Preconditions;
import de.cuioss.tools.io.FileLoader;
import de.cuioss.tools.io.FileTypePrefix;
import de.cuioss.tools.io.FilenameUtils;
import de.cuioss.tools.io.StructuredFilename;
import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.string.MoreStrings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public class ClassPathLoader
implements FileLoader {
    private static final long serialVersionUID = 9140071059594577808L;
    private static final CuiLogger log = new CuiLogger(ClassPathLoader.class);
    private final String normalizedPathName;
    private final String givenPathName;
    private final StructuredFilename fileName;
    private URL url;

    public ClassPathLoader(String pathName) {
        Objects.requireNonNull(pathName);
        this.givenPathName = pathName;
        this.normalizedPathName = ClassPathLoader.checkClasspathName(pathName);
        this.fileName = new StructuredFilename(FilenameUtils.getName(this.normalizedPathName));
    }

    static String checkClasspathName(String pathName) {
        MoreStrings.requireNotEmpty(pathName);
        if (FileTypePrefix.FILE.is(pathName)) {
            throw new IllegalArgumentException("Invalid path name, must start not start with " + FileTypePrefix.FILE + " but was: " + pathName);
        }
        Object newPathName = pathName;
        if (FileTypePrefix.CLASSPATH.is(pathName)) {
            newPathName = FileTypePrefix.CLASSPATH.removePrefix(pathName);
        }
        if (MoreStrings.isEmpty((CharSequence)newPathName)) {
            throw new IllegalArgumentException("Filename " + pathName + " is invalid");
        }
        if (((String)newPathName).indexOf(47) != 0) {
            newPathName = "/" + (String)newPathName;
        }
        return newPathName;
    }

    @Override
    public boolean isReadable() {
        return null != this.getURL();
    }

    @Override
    public InputStream inputStream() {
        Preconditions.checkState(this.isReadable(), "Resource '{}' is not readable", this.givenPathName);
        try {
            return this.getURL().openStream();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to load classpath file for " + this.givenPathName, e);
        }
    }

    @Override
    public boolean isFilesystemLoader() {
        return false;
    }

    @Override
    public URL getURL() {
        if (null == this.url) {
            this.url = ClassPathLoader.resolveUrl(this.normalizedPathName);
        }
        return this.url;
    }

    private static URL resolveUrl(String path) {
        log.debug("Resolving URL for '{}'", path);
        URL url = ClassPathLoader.class.getResource(path);
        if (null != url) {
            log.debug("Resolved '{}' from ClassPathLoader.class", path);
            return url;
        }
        Optional<ClassLoader> loader = Optional.ofNullable(Thread.currentThread().getContextClassLoader());
        if (loader.isPresent() && null != (url = loader.get().getResource(path))) {
            log.debug("Resolved '{}' from ContextClassLoader", path);
            return url;
        }
        log.warn("Unable to resolve '{}' from classpath", path);
        return null;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassPathLoader)) {
            return false;
        }
        ClassPathLoader other = (ClassPathLoader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$normalizedPathName = this.normalizedPathName;
        String other$normalizedPathName = other.normalizedPathName;
        return !(this$normalizedPathName == null ? other$normalizedPathName != null : !this$normalizedPathName.equals(other$normalizedPathName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClassPathLoader;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $normalizedPathName = this.normalizedPathName;
        result = result * 59 + ($normalizedPathName == null ? 43 : $normalizedPathName.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ClassPathLoader(normalizedPathName=" + this.normalizedPathName + ", givenPathName=" + this.givenPathName + ", fileName=" + this.getFileName() + ", url=" + this.getURL() + ")";
    }

    @Override
    @Generated
    public StructuredFilename getFileName() {
        return this.fileName;
    }
}

