/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.formatting.template.token;

import de.cuioss.tools.base.Preconditions;
import de.cuioss.tools.formatting.template.FormatterSupport;
import de.cuioss.tools.formatting.template.token.Token;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;

public class ActionToken
implements Token {
    private static final long serialVersionUID = -6329721490557755853L;
    private final String before;
    private final String attribute;
    private final String after;

    public ActionToken(String template, String token) {
        Preconditions.checkArgument(template.contains(token), "'" + template + " must contain '" + token + "'");
        List<String> splitted = Arrays.asList(template.split(token));
        this.before = ActionToken.extractSurrounding(splitted, 0);
        this.attribute = token;
        this.after = ActionToken.extractSurrounding(splitted, 1);
    }

    private static String extractSurrounding(List<String> splitted, int index) {
        String result = "";
        if (!splitted.isEmpty() && splitted.size() > index) {
            result = splitted.get(index);
        }
        return result;
    }

    @Override
    public String substituteAttribute(FormatterSupport content) {
        Objects.requireNonNull(content, "Content must not be null. ");
        Map<String, Serializable> attributeValues = Objects.requireNonNull(content.getAvailablePropertyValues(), "AvailablePropertyValues must not be null. ");
        StringBuilder result = new StringBuilder();
        if (attributeValues.containsKey(this.attribute)) {
            if (attributeValues.size() > 1) {
                result.append(this.before).append(attributeValues.get(this.attribute)).append(this.after);
            } else {
                result.append(attributeValues.get(this.attribute).toString());
            }
        }
        return result.toString();
    }

    @Override
    public boolean isStringToken() {
        return false;
    }

    @Generated
    public String toString() {
        return "ActionToken(before=" + this.before + ", attribute=" + this.attribute + ", after=" + this.after + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActionToken)) {
            return false;
        }
        ActionToken other = (ActionToken)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$before = this.before;
        String other$before = other.before;
        if (this$before == null ? other$before != null : !this$before.equals(other$before)) {
            return false;
        }
        String this$attribute = this.attribute;
        String other$attribute = other.attribute;
        if (this$attribute == null ? other$attribute != null : !this$attribute.equals(other$attribute)) {
            return false;
        }
        String this$after = this.after;
        String other$after = other.after;
        return !(this$after == null ? other$after != null : !this$after.equals(other$after));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ActionToken;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $before = this.before;
        result = result * 59 + ($before == null ? 43 : $before.hashCode());
        String $attribute = this.attribute;
        result = result * 59 + ($attribute == null ? 43 : $attribute.hashCode());
        String $after = this.after;
        result = result * 59 + ($after == null ? 43 : $after.hashCode());
        return result;
    }
}

