/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.net.ssl;

import de.cuioss.tools.base.BooleanOperations;
import de.cuioss.tools.base.Preconditions;
import de.cuioss.tools.io.MorePaths;
import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.net.ssl.KeyMaterialHolder;
import de.cuioss.tools.net.ssl.KeyStoreType;
import de.cuioss.tools.string.MoreStrings;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public class KeyStoreProvider
implements Serializable {
    private static final String UNABLE_TO_CREATE_KEYSTORE = "The creation of a KeyStore did not succeed";
    private static final String UNABLE_TO_CREATE_CERTIFICATE = "The creation of a Certificate-Object did not succeed";
    private static final CuiLogger log = new CuiLogger(KeyStoreProvider.class);
    private static final long serialVersionUID = 496381186621534386L;
    @NonNull
    private final KeyStoreType keyStoreType;
    private final File location;
    private final String storePassword;
    private final String keyPassword;
    private final Collection<KeyMaterialHolder> keys;

    public Optional<KeyStore> resolveKeyStore() {
        boolean[] blArray = new boolean[2];
        blArray[0] = this.keys.isEmpty();
        boolean bl = blArray[1] = null == this.location;
        if (BooleanOperations.areAllTrue(blArray)) {
            log.debug("Neither file nor keyMaterial provided, returning Optional#empty");
            return Optional.empty();
        }
        if (null != this.location) {
            log.debug("Checking whether configured {} path is readable", this.location.getAbsolutePath());
            Preconditions.checkState(MorePaths.checkReadablePath(this.location.toPath(), false, true), "'%s' is not readable check logs for reason", this.location.getAbsolutePath());
        }
        if (!this.keys.isEmpty()) {
            return this.retrieveFromKeys();
        }
        return this.retrieveFromFile();
    }

    private Optional<KeyStore> retrieveFromFile() {
        Optional<KeyStore> optional;
        log.debug("Retrieving java.security.KeyStore from configured file '{}'", this.location);
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(this.location));
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(input, this.getStorePasswordAsCharArray());
            optional = Optional.of(keyStore);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)input).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new IllegalStateException(UNABLE_TO_CREATE_KEYSTORE, e);
            }
        }
        ((InputStream)input).close();
        return optional;
    }

    private Optional<KeyStore> retrieveFromKeys() {
        log.debug("Retrieving java.security.KeyStore from configured keys");
        KeyStore keyStore = this.createEmptyKeyStore();
        block4: for (KeyMaterialHolder key : this.keys) {
            log.debug("Adding Key {}", key);
            Objects.requireNonNull(key);
            switch (key.getKeyHolderType()) {
                case SINGLE_KEY: {
                    KeyStoreProvider.addCertificateToKeyStore(key, keyStore);
                    continue block4;
                }
                case KEY_STORE: {
                    Preconditions.checkState(this.keys.size() == 1, "It is not allowed that there are multiple KeyStores");
                    keyStore = this.createKeyStoreFromByteArray(key);
                    continue block4;
                }
            }
            throw new UnsupportedOperationException("KeyHolderType is not defined: " + key.getKeyHolderType());
        }
        return Optional.of(keyStore);
    }

    private static void addCertificateToKeyStore(KeyMaterialHolder key, KeyStore keyStore) {
        CertificateFactory cf;
        try {
            cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new IllegalStateException("Unable to instantiate CertificateFactory", e);
        }
        try (ByteArrayInputStream certStream = new ByteArrayInputStream(key.getKeyMaterial());){
            Certificate cert = cf.generateCertificate(certStream);
            keyStore.setCertificateEntry(key.getKeyAlias(), cert);
        }
        catch (IOException | KeyStoreException | CertificateException e) {
            throw new IllegalStateException(UNABLE_TO_CREATE_CERTIFICATE, e);
        }
    }

    private KeyStore createKeyStoreFromByteArray(KeyMaterialHolder key) {
        KeyStore keyStore;
        KeyStore keyStore2;
        try {
            keyStore2 = KeyStore.getInstance(KeyStore.getDefaultType());
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("Unable to instantiate KeyStore", e);
        }
        ByteArrayInputStream keyStoreStream = new ByteArrayInputStream(key.getKeyMaterial());
        try {
            keyStore2.load(keyStoreStream, this.getStorePasswordAsCharArray());
            keyStore = keyStore2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)keyStoreStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | NoSuchAlgorithmException | CertificateException e) {
                throw new IllegalStateException(UNABLE_TO_CREATE_KEYSTORE, e);
            }
        }
        ((InputStream)keyStoreStream).close();
        return keyStore;
    }

    private KeyStore createEmptyKeyStore() {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, this.getStorePasswordAsCharArray());
            return keyStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IllegalStateException(UNABLE_TO_CREATE_KEYSTORE, e);
        }
    }

    public char[] getStorePasswordAsCharArray() {
        return KeyStoreProvider.toCharArray(this.storePassword);
    }

    public char[] getKeyPasswordAsCharArray() {
        return KeyStoreProvider.toCharArray(this.keyPassword);
    }

    public char[] getKeyOrStorePassword() {
        if (MoreStrings.isEmpty(this.keyPassword)) {
            return this.getStorePasswordAsCharArray();
        }
        return this.getKeyPasswordAsCharArray();
    }

    static final char[] toCharArray(String password) {
        if (MoreStrings.isEmpty(password)) {
            return new char[0];
        }
        return password.toCharArray();
    }

    @Generated
    KeyStoreProvider(@NonNull KeyStoreType keyStoreType, File location, String storePassword, String keyPassword, Collection<KeyMaterialHolder> keys) {
        if (keyStoreType == null) {
            throw new NullPointerException("keyStoreType is marked non-null but is null");
        }
        this.keyStoreType = keyStoreType;
        this.location = location;
        this.storePassword = storePassword;
        this.keyPassword = keyPassword;
        this.keys = keys;
    }

    @Generated
    public static KeyStoreProviderBuilder builder() {
        return new KeyStoreProviderBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyStoreProvider)) {
            return false;
        }
        KeyStoreProvider other = (KeyStoreProvider)o;
        if (!other.canEqual(this)) {
            return false;
        }
        KeyStoreType this$keyStoreType = this.keyStoreType;
        KeyStoreType other$keyStoreType = other.keyStoreType;
        if (this$keyStoreType == null ? other$keyStoreType != null : !((Object)((Object)this$keyStoreType)).equals((Object)other$keyStoreType)) {
            return false;
        }
        File this$location = this.location;
        File other$location = other.location;
        return !(this$location == null ? other$location != null : !((Object)this$location).equals(other$location));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KeyStoreProvider;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        KeyStoreType $keyStoreType = this.keyStoreType;
        result = result * 59 + ($keyStoreType == null ? 43 : ((Object)((Object)$keyStoreType)).hashCode());
        File $location = this.location;
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "KeyStoreProvider(keyStoreType=" + this.keyStoreType + ", location=" + this.location + ")";
    }

    @NonNull
    @Generated
    public KeyStoreType getKeyStoreType() {
        return this.keyStoreType;
    }

    @Generated
    public File getLocation() {
        return this.location;
    }

    @Generated
    public String getStorePassword() {
        return this.storePassword;
    }

    @Generated
    public String getKeyPassword() {
        return this.keyPassword;
    }

    @Generated
    public Collection<KeyMaterialHolder> getKeys() {
        return this.keys;
    }

    @Generated
    public static class KeyStoreProviderBuilder {
        @Generated
        private KeyStoreType keyStoreType;
        @Generated
        private File location;
        @Generated
        private String storePassword;
        @Generated
        private String keyPassword;
        @Generated
        private ArrayList<KeyMaterialHolder> keys;

        @Generated
        KeyStoreProviderBuilder() {
        }

        @Generated
        public KeyStoreProviderBuilder keyStoreType(@NonNull KeyStoreType keyStoreType) {
            if (keyStoreType == null) {
                throw new NullPointerException("keyStoreType is marked non-null but is null");
            }
            this.keyStoreType = keyStoreType;
            return this;
        }

        @Generated
        public KeyStoreProviderBuilder location(File location) {
            this.location = location;
            return this;
        }

        @Generated
        public KeyStoreProviderBuilder storePassword(String storePassword) {
            this.storePassword = storePassword;
            return this;
        }

        @Generated
        public KeyStoreProviderBuilder keyPassword(String keyPassword) {
            this.keyPassword = keyPassword;
            return this;
        }

        @Generated
        public KeyStoreProviderBuilder key(KeyMaterialHolder key) {
            if (this.keys == null) {
                this.keys = new ArrayList();
            }
            this.keys.add(key);
            return this;
        }

        @Generated
        public KeyStoreProviderBuilder keys(Collection<? extends KeyMaterialHolder> keys) {
            if (keys == null) {
                throw new NullPointerException("keys cannot be null");
            }
            if (this.keys == null) {
                this.keys = new ArrayList();
            }
            this.keys.addAll(keys);
            return this;
        }

        @Generated
        public KeyStoreProviderBuilder clearKeys() {
            if (this.keys != null) {
                this.keys.clear();
            }
            return this;
        }

        @Generated
        public KeyStoreProvider build() {
            return new KeyStoreProvider(this.keyStoreType, this.location, this.storePassword, this.keyPassword, switch (this.keys == null ? 0 : this.keys.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.keys.get(0));
                default -> Collections.unmodifiableList(new ArrayList<KeyMaterialHolder>(this.keys));
            });
        }

        @Generated
        public String toString() {
            return "KeyStoreProvider.KeyStoreProviderBuilder(keyStoreType=" + this.keyStoreType + ", location=" + this.location + ", storePassword=" + this.storePassword + ", keyPassword=" + this.keyPassword + ", keys=" + this.keys + ")";
        }
    }
}

