/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.concurrent;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public final class ConcurrentTools {
    public static void sleepUninterruptedly(Duration sleepFor) {
        ConcurrentTools.sleepUninterruptedly(ConcurrentTools.saturatedToNanos(sleepFor), TimeUnit.NANOSECONDS);
    }

    public static void sleepUninterruptedly(long sleepFor, TimeUnit unit) {
        boolean interrupted = false;
        try {
            long remainingNanos = unit.toNanos(sleepFor);
            long end = System.nanoTime() + remainingNanos;
            while (true) {
                try {
                    TimeUnit.NANOSECONDS.sleep(remainingNanos);
                    return;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    remainingNanos = end - System.nanoTime();
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    static long saturatedToNanos(Duration duration) {
        if (duration.isNegative() || duration.isZero()) {
            return 0L;
        }
        try {
            return duration.toNanos();
        }
        catch (ArithmeticException e) {
            return Long.MAX_VALUE;
        }
    }

    @Generated
    private ConcurrentTools() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

