/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.net;

import java.net.IDN;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;

public final class IDNInternetAddress {
    private static final Pattern addressPatternWithDisplayName = Pattern.compile("(.{0,64})<(.{1,64})@(.{1,64})>(.{0,64})");
    private static final Pattern addressPattern = Pattern.compile("(.{1,64})@(.{1,64})");

    public static String encode(@NonNull String completeAddress) {
        if (completeAddress == null) {
            throw new NullPointerException("completeAddress is marked non-null but is null");
        }
        return IDNInternetAddress.encode(completeAddress, untrustedHtml -> untrustedHtml);
    }

    public static String encode(@NonNull String completeAddress, UnaryOperator<String> sanitizer) {
        if (completeAddress == null) {
            throw new NullPointerException("completeAddress is marked non-null but is null");
        }
        Matcher matcher = addressPatternWithDisplayName.matcher(completeAddress);
        if (matcher.matches() && matcher.groupCount() == 4) {
            return (String)sanitizer.apply(matcher.group(1)) + "<" + (String)sanitizer.apply(matcher.group(2)) + "@" + (String)sanitizer.apply(IDN.toASCII(matcher.group(3))) + ">" + (String)sanitizer.apply(matcher.group(4));
        }
        matcher = addressPattern.matcher(completeAddress);
        if (matcher.matches() && matcher.groupCount() == 2) {
            return (String)sanitizer.apply(matcher.group(1)) + "@" + (String)sanitizer.apply(IDN.toASCII(matcher.group(2)));
        }
        return (String)sanitizer.apply(completeAddress);
    }

    public static String decode(@NonNull String completeAddress) {
        if (completeAddress == null) {
            throw new NullPointerException("completeAddress is marked non-null but is null");
        }
        return IDNInternetAddress.decode(completeAddress, untrustedHtml -> untrustedHtml);
    }

    public static String decode(@NonNull String completeAddress, UnaryOperator<String> sanitizer) {
        if (completeAddress == null) {
            throw new NullPointerException("completeAddress is marked non-null but is null");
        }
        Matcher matcher = addressPatternWithDisplayName.matcher(completeAddress);
        if (matcher.matches() && matcher.groupCount() == 4) {
            return (String)sanitizer.apply(matcher.group(1)) + "<" + (String)sanitizer.apply(matcher.group(2)) + "@" + (String)sanitizer.apply(IDN.toUnicode(matcher.group(3))) + ">" + (String)sanitizer.apply(matcher.group(4));
        }
        matcher = addressPattern.matcher(completeAddress);
        if (matcher.matches() && matcher.groupCount() == 2) {
            return (String)sanitizer.apply(matcher.group(1)) + "@" + (String)sanitizer.apply(IDN.toUnicode(matcher.group(2)));
        }
        return (String)sanitizer.apply(completeAddress);
    }

    @Generated
    private IDNInternetAddress() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

