/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.net.ssl;

import de.cuioss.tools.net.ssl.KeyAlgorithm;
import de.cuioss.tools.net.ssl.KeyHolderType;
import de.cuioss.tools.net.ssl.KeyStoreProvider;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Base64;
import lombok.Generated;
import lombok.NonNull;

public final class KeyMaterialHolder
implements Serializable {
    private static final long serialVersionUID = -3125499798220509939L;
    private final byte @NonNull [] keyMaterial;
    private final String keyPassword;
    private final String name;
    private final String description;
    private final String keyAlias;
    private final KeyHolderType keyHolderType;
    private final KeyAlgorithm keyAlgorithm;

    public char[] getKeyPasswordAsCharArray() {
        return KeyStoreProvider.toCharArray(this.keyPassword);
    }

    public static byte[] deserializeKeyMaterial(String serializedKeyMaterial) {
        return Base64.getDecoder().decode(serializedKeyMaterial);
    }

    public static String serializeKeyMaterial(byte[] keyMaterial) {
        return Base64.getEncoder().encodeToString(keyMaterial);
    }

    @Generated
    private static KeyHolderType $default$keyHolderType() {
        return KeyHolderType.SINGLE_KEY;
    }

    @Generated
    private static KeyAlgorithm $default$keyAlgorithm() {
        return KeyAlgorithm.UNDEFINED;
    }

    @Generated
    KeyMaterialHolder(byte @NonNull [] keyMaterial, String keyPassword, String name, String description, String keyAlias, KeyHolderType keyHolderType, KeyAlgorithm keyAlgorithm) {
        if (keyMaterial == null) {
            throw new NullPointerException("keyMaterial is marked non-null but is null");
        }
        this.keyMaterial = keyMaterial;
        this.keyPassword = keyPassword;
        this.name = name;
        this.description = description;
        this.keyAlias = keyAlias;
        this.keyHolderType = keyHolderType;
        this.keyAlgorithm = keyAlgorithm;
    }

    @Generated
    public static KeyMaterialHolderBuilder builder() {
        return new KeyMaterialHolderBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyMaterialHolder)) {
            return false;
        }
        KeyMaterialHolder other = (KeyMaterialHolder)o;
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.description;
        String other$description = other.description;
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$keyAlias = this.keyAlias;
        String other$keyAlias = other.keyAlias;
        if (this$keyAlias == null ? other$keyAlias != null : !this$keyAlias.equals(other$keyAlias)) {
            return false;
        }
        KeyHolderType this$keyHolderType = this.keyHolderType;
        KeyHolderType other$keyHolderType = other.keyHolderType;
        if (this$keyHolderType == null ? other$keyHolderType != null : !((Object)((Object)this$keyHolderType)).equals((Object)other$keyHolderType)) {
            return false;
        }
        KeyAlgorithm this$keyAlgorithm = this.keyAlgorithm;
        KeyAlgorithm other$keyAlgorithm = other.keyAlgorithm;
        return !(this$keyAlgorithm == null ? other$keyAlgorithm != null : !((Object)((Object)this$keyAlgorithm)).equals((Object)other$keyAlgorithm));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.description;
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $keyAlias = this.keyAlias;
        result = result * 59 + ($keyAlias == null ? 43 : $keyAlias.hashCode());
        KeyHolderType $keyHolderType = this.keyHolderType;
        result = result * 59 + ($keyHolderType == null ? 43 : ((Object)((Object)$keyHolderType)).hashCode());
        KeyAlgorithm $keyAlgorithm = this.keyAlgorithm;
        result = result * 59 + ($keyAlgorithm == null ? 43 : ((Object)((Object)$keyAlgorithm)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "KeyMaterialHolder(name=" + this.name + ", description=" + this.description + ", keyAlias=" + this.keyAlias + ", keyHolderType=" + String.valueOf((Object)this.keyHolderType) + ", keyAlgorithm=" + String.valueOf((Object)this.keyAlgorithm) + ")";
    }

    @Generated
    public byte @NonNull [] getKeyMaterial() {
        return this.keyMaterial;
    }

    @Generated
    public String getKeyPassword() {
        return this.keyPassword;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getKeyAlias() {
        return this.keyAlias;
    }

    @Generated
    public KeyHolderType getKeyHolderType() {
        return this.keyHolderType;
    }

    @Generated
    public KeyAlgorithm getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    @Generated
    public static class KeyMaterialHolderBuilder {
        @Generated
        private byte @NonNull [] keyMaterial;
        @Generated
        private String keyPassword;
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private String keyAlias;
        @Generated
        private boolean keyHolderType$set;
        @Generated
        private KeyHolderType keyHolderType$value;
        @Generated
        private boolean keyAlgorithm$set;
        @Generated
        private KeyAlgorithm keyAlgorithm$value;

        @Generated
        KeyMaterialHolderBuilder() {
        }

        @Generated
        public KeyMaterialHolderBuilder keyMaterial(byte @NonNull [] keyMaterial) {
            if (keyMaterial == null) {
                throw new NullPointerException("keyMaterial is marked non-null but is null");
            }
            this.keyMaterial = keyMaterial;
            return this;
        }

        @Generated
        public KeyMaterialHolderBuilder keyPassword(String keyPassword) {
            this.keyPassword = keyPassword;
            return this;
        }

        @Generated
        public KeyMaterialHolderBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public KeyMaterialHolderBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public KeyMaterialHolderBuilder keyAlias(String keyAlias) {
            this.keyAlias = keyAlias;
            return this;
        }

        @Generated
        public KeyMaterialHolderBuilder keyHolderType(KeyHolderType keyHolderType) {
            this.keyHolderType$value = keyHolderType;
            this.keyHolderType$set = true;
            return this;
        }

        @Generated
        public KeyMaterialHolderBuilder keyAlgorithm(KeyAlgorithm keyAlgorithm) {
            this.keyAlgorithm$value = keyAlgorithm;
            this.keyAlgorithm$set = true;
            return this;
        }

        @Generated
        public KeyMaterialHolder build() {
            KeyHolderType keyHolderType$value = this.keyHolderType$value;
            if (!this.keyHolderType$set) {
                keyHolderType$value = KeyMaterialHolder.$default$keyHolderType();
            }
            KeyAlgorithm keyAlgorithm$value = this.keyAlgorithm$value;
            if (!this.keyAlgorithm$set) {
                keyAlgorithm$value = KeyMaterialHolder.$default$keyAlgorithm();
            }
            return new KeyMaterialHolder(this.keyMaterial, this.keyPassword, this.name, this.description, this.keyAlias, keyHolderType$value, keyAlgorithm$value);
        }

        @Generated
        public String toString() {
            return "KeyMaterialHolder.KeyMaterialHolderBuilder(keyMaterial=" + Arrays.toString(this.keyMaterial) + ", keyPassword=" + this.keyPassword + ", name=" + this.name + ", description=" + this.description + ", keyAlias=" + this.keyAlias + ", keyHolderType$value=" + String.valueOf((Object)this.keyHolderType$value) + ", keyAlgorithm$value=" + String.valueOf((Object)this.keyAlgorithm$value) + ")";
        }
    }
}

