/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.property;

import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.reflect.MoreReflection;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Optional;

public enum PropertyMemberInfo {
    DEFAULT,
    NO_IDENTITY,
    TRANSIENT,
    UNDEFINED;

    private static final CuiLogger LOGGER;

    public static PropertyMemberInfo resolveForBean(Class<?> beanType, String propertyName) {
        Optional<Field> fieldOption = MoreReflection.accessField(beanType, propertyName);
        if (fieldOption.isEmpty()) {
            LOGGER.debug("No property descriptor found for property %s on type %s", propertyName, beanType);
            return UNDEFINED;
        }
        if (Modifier.isTransient(fieldOption.get().getModifiers())) {
            return TRANSIENT;
        }
        return DEFAULT;
    }

    static {
        LOGGER = new CuiLogger(PropertyMemberInfo.class);
    }
}

