/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.reflect;

import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.reflect.MoreReflection;
import de.cuioss.tools.string.MoreStrings;
import java.lang.reflect.Field;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public class FieldWrapper {
    private static final CuiLogger LOGGER = new CuiLogger(FieldWrapper.class);
    private final Field field;
    private final Class<?> declaringClass;

    public FieldWrapper(@NonNull Field field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        this.field = field;
        this.declaringClass = field.getDeclaringClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Object> readValue(Object source) {
        if (null == source) {
            LOGGER.trace("No Object given, returning Optional#empty()");
            return Optional.empty();
        }
        if (!this.declaringClass.isAssignableFrom(source.getClass())) {
            LOGGER.trace("Given Object is improper type, returning Optional#empty()");
            return Optional.empty();
        }
        boolean initialAccessible = this.field.canAccess(source);
        LOGGER.trace("Reading from field '{}' with accessibleFlag='{}' ", this.field, initialAccessible);
        Field field = this.field;
        synchronized (field) {
            Optional<Object> optional;
            block13: {
                if (!initialAccessible) {
                    LOGGER.trace("Explicitly setting accessible flag");
                    this.field.setAccessible(true);
                }
                try {
                    optional = Optional.ofNullable(this.field.get(source));
                    if (initialAccessible) break block13;
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    Optional<Object> optional2;
                    block14: {
                        try {
                            LOGGER.warn(e, "Reading from field '{}' with accessible='{}' and parameter ='{}' could not complete", this.field, initialAccessible, source);
                            optional2 = Optional.empty();
                            if (initialAccessible) break block14;
                            LOGGER.trace("Resetting accessible flag");
                            this.field.setAccessible(false);
                        }
                        catch (Throwable throwable) {
                            if (!initialAccessible) {
                                LOGGER.trace("Resetting accessible flag");
                                this.field.setAccessible(false);
                            }
                            throw throwable;
                        }
                    }
                    return optional2;
                }
                LOGGER.trace("Resetting accessible flag");
                this.field.setAccessible(false);
            }
            return optional;
        }
    }

    public static Optional<Object> readValue(String fieldName, Object object) {
        Optional<FieldWrapper> fieldProvider = FieldWrapper.from(object.getClass(), fieldName);
        LOGGER.trace("FieldWrapper: {}", fieldProvider);
        if (fieldProvider.isPresent()) {
            FieldWrapper fieldWrapper = fieldProvider.get();
            return fieldWrapper.readValue(object);
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeValue(@NonNull Object target, Object value) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        boolean initialAccessible = this.field.canAccess(target);
        LOGGER.trace("Writing to field '{}' with accessibleFlag='{}' ", this.field, initialAccessible);
        Field field = this.field;
        synchronized (field) {
            if (!initialAccessible) {
                LOGGER.trace("Explicitly setting accessible flag");
                this.field.setAccessible(true);
            }
            try {
                this.field.set(target, value);
            }
            catch (IllegalAccessException e) {
                String message = MoreStrings.lenientFormat("Writing to field '{}' with accessible='{}' and parameter ='{}' could not complete", this.field, initialAccessible, target);
                throw new IllegalStateException(message, e);
            }
            finally {
                if (!initialAccessible) {
                    LOGGER.trace("Resetting accessible flag");
                    this.field.setAccessible(false);
                }
            }
        }
    }

    public static Optional<FieldWrapper> from(Class<?> type, String fieldName) {
        Optional<Field> loaded = MoreReflection.accessField(type, fieldName);
        return loaded.map(FieldWrapper::new);
    }

    @Generated
    public Field getField() {
        return this.field;
    }
}

