/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.property;

import de.cuioss.tools.base.Preconditions;
import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.reflect.MoreReflection;
import de.cuioss.tools.string.MoreStrings;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public final class PropertyUtil {
    private static final CuiLogger LOGGER = new CuiLogger(PropertyUtil.class);
    public static final String UNABLE_TO_READ_PROPERTY = "Unable to read property '%s' from type '%s'";
    public static final String UNABLE_TO_WRITE_PROPERTY = "Unable to write property '%s' to type '%s', expected type was '%s'";
    public static final String UNABLE_TO_WRITE_PROPERTY_RUNTIME = "Unable to write property '%s' to type '%s'";

    public static Object readProperty(Object bean, String propertyName) {
        LOGGER.debug("Reading property '%s' from %s", propertyName, bean);
        Objects.requireNonNull(bean);
        MoreStrings.requireNotEmptyTrimmed(propertyName);
        Optional<Method> reader = MoreReflection.retrieveAccessMethod(bean.getClass(), propertyName);
        Preconditions.checkArgument(reader.isPresent(), UNABLE_TO_READ_PROPERTY, propertyName, bean.getClass());
        try {
            return reader.get().invoke(bean, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            LOGGER.debug("Property read failed due to access restrictions", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(MoreStrings.lenientFormat(UNABLE_TO_READ_PROPERTY, propertyName, bean.getClass()), e);
        }
        return null;
    }

    public static Object writeProperty(Object bean, String propertyName, Object propertyValue) {
        LOGGER.debug("Writing '%s' to property '%s' on '%s'", propertyValue, propertyName, bean);
        Objects.requireNonNull(bean);
        MoreStrings.requireNotEmptyTrimmed(propertyName);
        Method writeMethod = PropertyUtil.determineWriteMethod(bean, propertyName, propertyValue);
        try {
            Object result = writeMethod.invoke(bean, propertyValue);
            return Objects.requireNonNullElse(result, bean);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            LOGGER.debug("Property write failed due to access restrictions", e);
        }
        catch (InvocationTargetException e) {
            String target = propertyValue != null ? propertyValue.getClass().getName() : "Undefined";
            throw new IllegalStateException(MoreStrings.lenientFormat(UNABLE_TO_WRITE_PROPERTY_RUNTIME, propertyName, bean.getClass(), target), e);
        }
        return bean;
    }

    public static Optional<Class<?>> resolvePropertyType(Class<?> beanClass, String propertyName) {
        Optional<Method> retrieveAccessMethod = MoreReflection.retrieveAccessMethod(beanClass, propertyName);
        if (retrieveAccessMethod.isPresent()) {
            LOGGER.trace("Found read-method on class '%s' for property-name '%s'", beanClass, propertyName);
            return Optional.of(retrieveAccessMethod.get().getReturnType());
        }
        Optional<Field> field = MoreReflection.accessField(beanClass, propertyName);
        if (field.isPresent()) {
            LOGGER.trace("Found field on class '%s' with name '%s'", beanClass, propertyName);
            return Optional.of(field.get().getType());
        }
        LOGGER.debug("Neither read-method nor field found on class '%s' for property-name '%s', checking write methods, returning first type found", beanClass, propertyName);
        Collection<Method> candidates = MoreReflection.retrieveWriteMethodCandidates(beanClass, propertyName);
        if (!candidates.isEmpty()) {
            return Optional.of(candidates.iterator().next().getParameterTypes()[0]);
        }
        LOGGER.debug("Unable to detect property-type on class '%s' for property-name '%s'", beanClass, propertyName);
        return Optional.empty();
    }

    private static Method determineWriteMethod(Object bean, String propertyName, Object propertyValue) {
        Collection<Method> candidates = MoreReflection.retrieveWriteMethodCandidates(bean.getClass(), propertyName);
        String target = propertyValue != null ? propertyValue.getClass().getName() : "Undefined";
        Preconditions.checkArgument(!candidates.isEmpty(), UNABLE_TO_WRITE_PROPERTY, propertyName, bean.getClass(), target);
        if (null == propertyValue) {
            LOGGER.trace("No / Null propertyValue given, so any method should suffice to write property '%s' to %s", propertyName, bean);
            return candidates.iterator().next();
        }
        for (Method candidate : candidates) {
            if (!MoreReflection.checkWhetherParameterIsAssignable(candidate.getParameterTypes()[0], propertyValue.getClass())) continue;
            LOGGER.trace("Found method %s to write property '%s' to %s", candidate, propertyName, bean);
            return candidate;
        }
        throw new IllegalArgumentException(MoreStrings.lenientFormat(UNABLE_TO_WRITE_PROPERTY, propertyName, bean.getClass(), target));
    }

    @Generated
    private PropertyUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

