/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.string;

import de.cuioss.tools.collect.CollectionBuilder;
import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.string.MoreStrings;
import de.cuioss.tools.string.SplitterConfig;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;

public final class Splitter {
    private static final CuiLogger LOGGER = new CuiLogger(Splitter.class);
    @NonNull
    private final SplitterConfig splitterConfig;

    public static Splitter on(char separator) {
        Objects.requireNonNull(Character.valueOf(separator), "separator must not be null");
        String separatorStr = String.valueOf(separator);
        return new Splitter(SplitterConfig.builder().separator(separatorStr).pattern(Pattern.compile(Pattern.quote(separatorStr))).build());
    }

    public static Splitter on(String separator) {
        Objects.requireNonNull(separator, "separator must not be null");
        if (separator.isEmpty()) {
            throw new IllegalArgumentException("separator must not be empty");
        }
        return new Splitter(SplitterConfig.builder().separator(separator).pattern(Pattern.compile(Pattern.quote(separator))).build());
    }

    public static Splitter on(Pattern separatorPattern) {
        Objects.requireNonNull(separatorPattern, "separatorPattern must not be null");
        return new Splitter(SplitterConfig.builder().separator(separatorPattern.pattern()).pattern(separatorPattern).build());
    }

    public Splitter limit(int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException("limit must be greater than 0");
        }
        SplitterConfig newConfig = this.splitterConfig.copy().maxItems(limit).pattern(this.splitterConfig.getPattern()).build();
        return new Splitter(newConfig);
    }

    public Splitter trimResults() {
        SplitterConfig newConfig = this.splitterConfig.copy().trimResults(true).pattern(this.splitterConfig.getPattern()).build();
        return new Splitter(newConfig);
    }

    public Splitter omitEmptyStrings() {
        SplitterConfig newConfig = this.splitterConfig.copy().omitEmptyStrings(true).pattern(this.splitterConfig.getPattern()).build();
        return new Splitter(newConfig);
    }

    public Splitter doNotModifySeparatorString() {
        String separator = this.splitterConfig.getSeparator();
        SplitterConfig newConfig = this.splitterConfig.copy().doNotModifySeparatorString(true).pattern(Pattern.compile(Pattern.quote(separator))).build();
        return new Splitter(newConfig);
    }

    public List<String> splitToList(String sequence) {
        String[] splitted;
        if (null == sequence) {
            return Collections.emptyList();
        }
        if (this.splitterConfig.isDoNotModifySeparatorString() && this.splitterConfig.getSeparator().matches(".*[\\[\\]\\{\\}\\(\\)\\*\\+\\?\\^\\$\\|\\\\].*")) {
            throw new IllegalArgumentException("Invalid regex pattern: " + this.splitterConfig.getSeparator());
        }
        LOGGER.debug("Splitting '%s' with pattern '%s'", sequence, this.splitterConfig.getSeparator());
        if (MoreStrings.isEmpty(sequence)) {
            return Collections.emptyList();
        }
        Pattern pattern = this.splitterConfig.getPattern();
        if (pattern == null) {
            pattern = Pattern.compile(Pattern.quote(this.splitterConfig.getSeparator()));
        }
        if (0 == (splitted = sequence.split(pattern.pattern(), this.splitterConfig.getMaxItems())).length) {
            LOGGER.trace("No content to be returned for input {} and configuration {}", sequence, this.splitterConfig);
            return Collections.emptyList();
        }
        CollectionBuilder<String> builder = new CollectionBuilder<String>();
        for (String element : splitted) {
            this.addIfApplicable(builder, element);
        }
        return builder.toImmutableList();
    }

    private void addIfApplicable(CollectionBuilder<String> builder, String element) {
        if (null == element) {
            return;
        }
        String toDo = element;
        if (this.splitterConfig.isTrimResults()) {
            toDo = toDo.trim();
        }
        if (!this.splitterConfig.isOmitEmptyStrings() || !toDo.isEmpty()) {
            builder.add(toDo);
        }
    }

    @Generated
    Splitter(@NonNull SplitterConfig splitterConfig) {
        if (splitterConfig == null) {
            throw new NullPointerException("splitterConfig is marked non-null but is null");
        }
        this.splitterConfig = splitterConfig;
    }
}

