/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.codec;

import de.cuioss.tools.codec.DecoderException;
import de.cuioss.tools.codec.EncoderException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import lombok.Generated;

public class Hex {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final Charset charset;

    public static byte[] decodeHex(String data) throws DecoderException {
        return Hex.decodeHex(data.toCharArray());
    }

    public static byte[] decodeHex(char[] data) throws DecoderException {
        int len = data.length;
        if ((len & 1) != 0) {
            throw new DecoderException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = Hex.toDigit(data[j], j) << 4;
            f |= Hex.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    public static char[] encodeHex(byte[] data) {
        return Hex.encodeHex(data, true);
    }

    public static char[] encodeHex(ByteBuffer data) {
        return Hex.encodeHex(data, true);
    }

    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        return Hex.encodeHex(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    public static char[] encodeHex(ByteBuffer data, boolean toLowerCase) {
        return Hex.encodeHex(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static char[] encodeHex(byte[] data, char[] toDigits) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j] = toDigits[(0xF0 & data[i]) >>> 4];
            out[++j] = toDigits[0xF & data[i]];
            ++j;
        }
        return out;
    }

    protected static char[] encodeHex(ByteBuffer byteBuffer, char[] toDigits) {
        return Hex.encodeHex(Hex.toByteArray(byteBuffer), toDigits);
    }

    public static String encodeHexString(byte[] data) {
        return new String(Hex.encodeHex(data));
    }

    public static String encodeHexString(byte[] data, boolean toLowerCase) {
        return new String(Hex.encodeHex(data, toLowerCase));
    }

    public static String encodeHexString(ByteBuffer data) {
        return new String(Hex.encodeHex(data));
    }

    public static String encodeHexString(ByteBuffer data, boolean toLowerCase) {
        return new String(Hex.encodeHex(data, toLowerCase));
    }

    private static byte[] toByteArray(ByteBuffer byteBuffer) {
        byte[] byteArray;
        int remaining = byteBuffer.remaining();
        if (byteBuffer.hasArray() && remaining == (byteArray = byteBuffer.array()).length) {
            byteBuffer.position(remaining);
            return byteArray;
        }
        byteArray = new byte[remaining];
        byteBuffer.get(byteArray);
        return byteArray;
    }

    protected static int toDigit(char ch, int index) throws DecoderException {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new DecoderException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }

    public Hex() {
        this.charset = DEFAULT_CHARSET;
    }

    public Hex(Charset charset) {
        this.charset = charset;
    }

    public Hex(String charsetName) {
        this(Charset.forName(charsetName));
    }

    public byte[] decode(byte[] object) throws DecoderException {
        return Hex.decodeHex(new String(object, this.getCharset()).toCharArray());
    }

    public byte[] decode(ByteBuffer object) throws DecoderException {
        return Hex.decodeHex(new String(Hex.toByteArray(object), this.getCharset()).toCharArray());
    }

    public Object decode(Object object) throws DecoderException {
        if (object instanceof String) {
            String string = (String)object;
            return this.decode(string.toCharArray());
        }
        if (object instanceof byte[]) {
            byte[] bytes = (byte[])object;
            return this.decode(bytes);
        }
        if (object instanceof ByteBuffer) {
            ByteBuffer buffer = (ByteBuffer)object;
            return this.decode(buffer);
        }
        try {
            return Hex.decodeHex((char[])object);
        }
        catch (ClassCastException e) {
            throw new DecoderException(e.getMessage(), e);
        }
    }

    public byte[] encode(byte[] array) {
        return Hex.encodeHexString(array).getBytes(this.getCharset());
    }

    public byte[] encode(ByteBuffer array) {
        return Hex.encodeHexString(array).getBytes(this.getCharset());
    }

    public Object encode(Object object) throws EncoderException {
        byte[] byteArray;
        Object object2 = object;
        Objects.requireNonNull(object2);
        Object object3 = object2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, ByteBuffer.class}, (Object)object3, n)) {
            case 0: {
                String string = (String)object3;
                byteArray = string.getBytes(this.getCharset());
                break;
            }
            case 1: {
                ByteBuffer buffer = (ByteBuffer)object3;
                byteArray = Hex.toByteArray(buffer);
                break;
            }
            default: {
                try {
                    byteArray = (byte[])object;
                    break;
                }
                catch (ClassCastException e) {
                    throw new EncoderException(e.getMessage(), e);
                }
            }
        }
        return Hex.encodeHex(byteArray);
    }

    @Generated
    public String toString() {
        return "Hex(charset=" + String.valueOf(this.getCharset()) + ")";
    }

    @Generated
    public Charset getCharset() {
        return this.charset;
    }
}

