/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.concurrent;

import de.cuioss.tools.concurrent.RingBufferStatistics;
import de.cuioss.tools.logging.CuiLogger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLongArray;
import lombok.NonNull;

public class RingBuffer {
    private static final CuiLogger LOGGER = new CuiLogger(RingBuffer.class);
    private final AtomicLongArray samples;
    private final int mask;
    private final AtomicInteger writeIndex = new AtomicInteger(0);
    private final AtomicInteger sampleCount = new AtomicInteger(0);
    @NonNull
    private final TimeUnit timeUnit;

    public RingBuffer(int capacity) {
        this(capacity, TimeUnit.MICROSECONDS);
    }

    public RingBuffer(int capacity, @NonNull TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new NullPointerException("timeUnit is marked non-null but is null");
        }
        if (capacity <= 0) {
            throw new IllegalArgumentException("Capacity must be positive: " + capacity);
        }
        int actualCapacity = RingBuffer.nextPowerOfTwo(capacity);
        this.samples = new AtomicLongArray(actualCapacity);
        this.mask = actualCapacity - 1;
        this.timeUnit = timeUnit;
        if (actualCapacity != capacity) {
            LOGGER.debug("Ring buffer capacity adjusted from %s to %s (next power of 2)", capacity, actualCapacity);
        }
    }

    public void recordMeasurement(long amount) {
        if (amount < 0L) {
            throw new IllegalArgumentException("Amount cannot be negative: " + amount);
        }
        int index = this.writeIndex.getAndIncrement() & this.mask;
        this.samples.set(index, amount);
        this.sampleCount.updateAndGet(current -> Math.min(current + 1, this.samples.length()));
    }

    public RingBufferStatistics getStatistics() {
        long[] snapshot = this.getSamplesSnapshot();
        return RingBufferStatistics.computeFrom(snapshot, this.timeUnit);
    }

    public long[] getSamplesSnapshot() {
        int count = this.sampleCount.get();
        if (count == 0) {
            return new long[0];
        }
        long[] snapshot = new long[count];
        for (int i = 0; i < count; ++i) {
            snapshot[i] = this.samples.get(i);
        }
        return snapshot;
    }

    public void reset() {
        this.writeIndex.set(0);
        this.sampleCount.set(0);
    }

    private static int nextPowerOfTwo(int value) {
        if (value <= 1) {
            return 1;
        }
        return Integer.highestOneBit(value - 1) << 1;
    }
}

