/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.concurrent;

import de.cuioss.tools.concurrent.RingBuffer;
import de.cuioss.tools.concurrent.StripedRingBufferStatistics;
import de.cuioss.tools.logging.CuiLogger;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;

public class StripedRingBuffer {
    private static final CuiLogger LOGGER = new CuiLogger(StripedRingBuffer.class);
    private static final int STRIPE_COUNT = StripedRingBuffer.nextPowerOfTwo(Math.max(4, Runtime.getRuntime().availableProcessors()));
    private final RingBuffer[] stripes;
    private final int stripeCount;
    @NonNull
    private final TimeUnit timeUnit;

    public StripedRingBuffer(int windowSize) {
        this(windowSize, TimeUnit.MICROSECONDS);
    }

    public StripedRingBuffer(int windowSize, @NonNull TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new NullPointerException("timeUnit is marked non-null but is null");
        }
        if (windowSize <= 0) {
            throw new IllegalArgumentException("Window size must be positive: " + windowSize);
        }
        this.stripeCount = STRIPE_COUNT;
        this.stripes = new RingBuffer[this.stripeCount];
        this.timeUnit = timeUnit;
        int sizePerStripe = Math.max(1, windowSize / this.stripeCount);
        for (int i = 0; i < this.stripeCount; ++i) {
            this.stripes[i] = new RingBuffer(sizePerStripe, timeUnit);
        }
        int actualTotalCapacity = sizePerStripe * this.stripeCount;
        if (actualTotalCapacity != windowSize) {
            LOGGER.debug("Striped ring buffer capacity adjusted from %s to %s (distributed across %s stripes)", windowSize, actualTotalCapacity, this.stripeCount);
        }
    }

    public void recordMeasurement(long amount) {
        if (amount < 0L) {
            throw new IllegalArgumentException("Amount cannot be negative: " + amount);
        }
        int stripeIndex = Thread.currentThread().hashCode() & Integer.MAX_VALUE & this.stripeCount - 1;
        this.stripes[stripeIndex].recordMeasurement(amount);
    }

    public StripedRingBufferStatistics getStatistics() {
        return StripedRingBufferStatistics.computeFrom(this.stripes, this.timeUnit);
    }

    public void reset() {
        for (RingBuffer stripe : this.stripes) {
            stripe.reset();
        }
    }

    private static int nextPowerOfTwo(int value) {
        if (value <= 1) {
            return 1;
        }
        return Integer.highestOneBit(value - 1) << 1;
    }
}

