/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.io;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import lombok.Generated;

public final class PathTraversalSecurity {
    public static void validatePathSegment(String pathSegment) {
        if (pathSegment != null && (pathSegment.contains("..") || pathSegment.contains("/") || pathSegment.contains("\\"))) {
            throw new IllegalArgumentException("Invalid path segment: potential path traversal detected in '" + pathSegment + "'");
        }
    }

    public static Path createSecureTempFile(String prefix, String suffix) throws IOException {
        try {
            Set<PosixFilePermission> perms = PosixFilePermissions.fromString("rw-------");
            FileAttribute<Set<PosixFilePermission>> attrs = PosixFilePermissions.asFileAttribute(perms);
            return Files.createTempFile(prefix, suffix, attrs);
        }
        catch (UnsupportedOperationException e) {
            Path tempFile = Files.createTempFile(prefix, suffix, new FileAttribute[0]);
            return tempFile;
        }
    }

    @Generated
    private PathTraversalSecurity() {
    }
}

