/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.io;

import de.cuioss.tools.base.Preconditions;
import de.cuioss.tools.io.FileLoader;
import de.cuioss.tools.io.FileTypePrefix;
import de.cuioss.tools.io.StructuredFilename;
import de.cuioss.tools.logging.CuiLogger;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public class UrlLoader
implements FileLoader {
    private static final long serialVersionUID = -8758614099334823819L;
    private static final CuiLogger LOGGER = new CuiLogger(UrlLoader.class);
    private final URL url;
    private transient URLConnection connection;

    public UrlLoader(String url) {
        Preconditions.checkArgument(null != url, "url must not be null");
        String sanitizedUrl = url;
        if (FileTypePrefix.URL.is(url)) {
            sanitizedUrl = FileTypePrefix.URL.removePrefix(url);
        }
        try {
            this.url = URI.create(sanitizedUrl).toURL();
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            throw new IllegalArgumentException("Provided URL is invalid: " + url, e);
        }
    }

    public UrlLoader(URL url) {
        Preconditions.checkArgument(null != url, "url must not be null");
        this.url = url;
    }

    @Override
    public InputStream inputStream() throws IOException {
        if (null == this.connection) {
            this.connection = this.url.openConnection();
            this.connection.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(5L));
            this.connection.setReadTimeout((int)TimeUnit.SECONDS.toMillis(5L));
        }
        return this.connection.getInputStream();
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public boolean isReadable() {
        try {
            this.inputStream().close();
            return true;
        }
        catch (IOException e) {
            LOGGER.debug("Resource not readable: %s", this.url, e);
            return false;
        }
    }

    @Override
    public StructuredFilename getFileName() {
        int queryStart;
        String path = this.url.getPath();
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash >= 0) {
            path = path.substring(lastSlash + 1);
        }
        if ((queryStart = path.indexOf(63)) >= 0) {
            path = path.substring(0, queryStart);
        }
        return new StructuredFilename(path);
    }

    @Override
    public boolean isFilesystemLoader() {
        return false;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UrlLoader)) {
            return false;
        }
        UrlLoader other = (UrlLoader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        URL this$url = this.getURL();
        URL other$url = other.getURL();
        return !(this$url == null ? other$url != null : !((Object)this$url).equals(other$url));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UrlLoader;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URL $url = this.getURL();
        result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "UrlLoader(url=" + String.valueOf(this.getURL()) + ")";
    }
}

