/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.logging;

import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.logging.LogRecord;
import de.cuioss.tools.string.MoreStrings;
import java.util.function.Supplier;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public class LogRecordModel
implements LogRecord {
    private static final String PREFIX_IDENTIFIER_TEMPLATE = "%s-%s";
    private static final String AFTER_PREFIX = ": ";
    private final String prefix;
    private final Integer identifier;
    private final String template;
    private @Nullable String parsedMessageTemplate;
    private @Nullable String parsedIdentifier;

    protected String getParsedMessageTemplate() {
        if (null == this.parsedMessageTemplate) {
            this.parsedMessageTemplate = CuiLogger.SLF4J_PATTERN.matcher(MoreStrings.nullToEmpty(this.getTemplate())).replaceAll("%s");
        }
        return this.parsedMessageTemplate;
    }

    @Override
    public String format(Object ... parameter) {
        return this.resolveIdentifierString() + AFTER_PREFIX + MoreStrings.lenientFormat(this.getParsedMessageTemplate(), parameter);
    }

    @Override
    public Supplier<String> supplier(Object ... parameter) {
        return () -> this.format(parameter);
    }

    @Override
    public String resolveIdentifierString() {
        if (null == this.parsedIdentifier) {
            this.parsedIdentifier = PREFIX_IDENTIFIER_TEMPLATE.formatted(this.getPrefix(), this.getIdentifier());
        }
        return this.parsedIdentifier;
    }

    private LogRecordModel(String prefix, Integer identifier, String template) {
        this.prefix = prefix;
        this.identifier = identifier;
        this.template = template;
    }

    @Generated
    public static LogRecordModelBuilder builder() {
        return new LogRecordModelBuilder();
    }

    @Override
    @Generated
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    @Generated
    public Integer getIdentifier() {
        return this.identifier;
    }

    @Override
    @Generated
    public String getTemplate() {
        return this.template;
    }

    @Generated
    public static class LogRecordModelBuilder {
        @Generated
        private String prefix;
        @Generated
        private Integer identifier;
        @Generated
        private String template;

        @Generated
        LogRecordModelBuilder() {
        }

        @Generated
        public LogRecordModelBuilder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        @Generated
        public LogRecordModelBuilder identifier(Integer identifier) {
            this.identifier = identifier;
            return this;
        }

        @Generated
        public LogRecordModelBuilder template(String template) {
            this.template = template;
            return this;
        }

        @Generated
        public LogRecordModel build() {
            return new LogRecordModel(this.prefix, this.identifier, this.template);
        }

        @Generated
        public String toString() {
            return "LogRecordModel.LogRecordModelBuilder(prefix=" + this.prefix + ", identifier=" + this.identifier + ", template=" + this.template + ")";
        }
    }
}

