/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.string;

import de.cuioss.tools.collect.CollectionLiterals;
import de.cuioss.tools.collect.MoreCollections;
import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.string.JoinerConfig;
import de.cuioss.tools.string.MoreStrings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

public final class Joiner {
    private static final CuiLogger LOGGER = new CuiLogger(Joiner.class);
    @NonNull
    private final JoinerConfig joinerConfig;

    @NonNull
    public static Joiner on(@NonNull String separator) {
        if (separator == null) {
            throw new NullPointerException("separator is marked non-null but is null");
        }
        return new Joiner(JoinerConfig.builder().separator(separator).build());
    }

    @NonNull
    public static Joiner on(char separator) {
        return Joiner.on(String.valueOf(separator));
    }

    public Joiner useForNull(String nullText) {
        return new Joiner(this.joinerConfig.copy().useForNull(nullText).build());
    }

    public Joiner skipNulls() {
        return new Joiner(this.joinerConfig.copy().skipNulls(true).build());
    }

    public Joiner skipEmptyStrings() {
        return new Joiner(this.joinerConfig.copy().skipEmpty(true).build());
    }

    public Joiner skipBlankStrings() {
        return new Joiner(this.joinerConfig.copy().skipBlank(true).build());
    }

    public String join(Iterable<?> parts) {
        return this.doJoin(parts);
    }

    public String join(Iterator<?> parts) {
        return this.doJoin(CollectionLiterals.mutableList(parts));
    }

    public String join(Object ... parts) {
        return this.doJoin(CollectionLiterals.mutableList(parts));
    }

    private String doJoin(Iterable<?> parts) {
        LOGGER.debug("Joining %s elements", parts);
        if (MoreCollections.isEmpty(parts)) {
            return "";
        }
        ArrayList builder = new ArrayList();
        for (Object element2 : parts) {
            if (null == element2) {
                if (this.joinerConfig.isSkipNulls()) continue;
                builder.add(this.joinerConfig.getUseForNull());
                continue;
            }
            if (element2 instanceof CharSequence) {
                CharSequence sequence = (CharSequence)element2;
                builder.add(sequence);
                continue;
            }
            builder.add(MoreStrings.lenientToString(element2));
        }
        if (this.joinerConfig.isSkipEmpty()) {
            builder = builder.stream().filter(element -> !MoreStrings.isEmpty(element)).collect(Collectors.toCollection(ArrayList::new));
        }
        if (this.joinerConfig.isSkipBlank()) {
            builder = builder.stream().filter(element -> !MoreStrings.isBlank(element)).collect(Collectors.toCollection(ArrayList::new));
        }
        return String.join((CharSequence)this.joinerConfig.getSeparator(), builder);
    }

    @Generated
    Joiner(@NonNull JoinerConfig joinerConfig) {
        if (joinerConfig == null) {
            throw new NullPointerException("joinerConfig is marked non-null but is null");
        }
        this.joinerConfig = joinerConfig;
    }
}

