/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.string;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import lombok.NonNull;

public final class MoreStrings {
    private static final Logger LOGGER = Logger.getLogger(MoreStrings.class.getName());
    public static final String EMPTY = "";
    public static final String SPACE = " ";
    public static final int INDEX_NOT_FOUND = -1;
    private static final int PAD_LIMIT = 8192;

    public static String unquote(String original) {
        if (MoreStrings.isEmpty(original)) {
            return original;
        }
        if (original.startsWith("\"") && original.endsWith("\"") || original.startsWith("'") && original.endsWith("'")) {
            return original.substring(1, original.length() - 1);
        }
        return original;
    }

    public static boolean isAllLowerCase(CharSequence cs) {
        if (MoreStrings.isEmpty(cs)) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isLowerCase(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllUpperCase(CharSequence cs) {
        if (MoreStrings.isEmpty(cs)) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isUpperCase(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.isEmpty();
    }

    public static boolean isPresent(CharSequence cs) {
        return cs != null && !cs.isEmpty();
    }

    public static boolean isNumeric(CharSequence cs) {
        if (MoreStrings.isEmpty(cs)) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !MoreStrings.isBlank(cs);
    }

    public static int countMatches(CharSequence str, CharSequence sub) {
        if (MoreStrings.isEmpty(str) || MoreStrings.isEmpty(sub)) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        while ((idx = MoreStrings.indexOf(str, sub, idx)) != -1) {
            ++count;
            idx += sub.length();
        }
        return count;
    }

    public static String leftPad(String str, int size) {
        return MoreStrings.leftPad(str, size, ' ');
    }

    public static String leftPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return MoreStrings.leftPad(str, size, String.valueOf(padChar));
        }
        return MoreStrings.repeat(padChar, pads).concat(str);
    }

    public static String leftPad(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (MoreStrings.isEmpty(padStr)) {
            padStr = SPACE;
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return MoreStrings.leftPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return padStr.concat(str);
        }
        if (pads < padLen) {
            return padStr.substring(0, pads).concat(str);
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return new String(padding).concat(str);
    }

    public static String repeat(char ch, int repeat) {
        if (repeat <= 0) {
            return EMPTY;
        }
        char[] buf = new char[repeat];
        for (int i = repeat - 1; i >= 0; --i) {
            buf[i] = ch;
        }
        return new String(buf);
    }

    public static String stripEnd(String str, String stripChars) {
        int end;
        if (str == null || (end = str.length()) == 0) {
            return str;
        }
        if (stripChars == null) {
            while (end != 0 && Character.isWhitespace(str.charAt(end - 1))) {
                --end;
            }
        } else {
            if (stripChars.isEmpty()) {
                return str;
            }
            while (end != 0 && stripChars.indexOf(str.charAt(end - 1)) != -1) {
                --end;
            }
        }
        return str.substring(0, end);
    }

    public static int indexOf(CharSequence seq, int searchChar) {
        if (MoreStrings.isEmpty(seq)) {
            return -1;
        }
        return MoreStrings.indexOf(seq, searchChar, 0);
    }

    public static int indexOf(CharSequence cs, int searchChar, int start) {
        if (MoreStrings.isEmpty(cs)) {
            return -1;
        }
        if (cs instanceof String) {
            String string = (String)cs;
            return string.indexOf(searchChar, start);
        }
        return MoreStrings.indexOfInCharSequence(cs, searchChar, MoreStrings.normalizeStartIndex(start));
    }

    private static int normalizeStartIndex(int start) {
        return Math.max(0, start);
    }

    private static int indexOfInCharSequence(CharSequence cs, int searchChar, int start) {
        if (searchChar < 65536) {
            return MoreStrings.indexOfBasicCharacter(cs, searchChar, start);
        }
        if (searchChar <= 0x10FFFF) {
            return MoreStrings.indexOfSupplementaryCharacter(cs, searchChar, start);
        }
        return -1;
    }

    private static int indexOfBasicCharacter(CharSequence cs, int searchChar, int start) {
        int sz = cs.length();
        for (int i = start; i < sz; ++i) {
            if (cs.charAt(i) != searchChar) continue;
            return i;
        }
        return -1;
    }

    private static int indexOfSupplementaryCharacter(CharSequence cs, int searchChar, int start) {
        char[] chars = Character.toChars(searchChar);
        int sz = cs.length();
        for (int i = start; i < sz - 1; ++i) {
            char high = cs.charAt(i);
            char low = cs.charAt(i + 1);
            if (high != chars[0] || low != chars[1]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(CharSequence cs, CharSequence searchChar, int start) {
        if (cs == null || searchChar == null) {
            return -1;
        }
        return cs.toString().indexOf(searchChar.toString(), start);
    }

    public static boolean hasNonWhitespaceChar(CharSequence str) {
        if (MoreStrings.isEmpty(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String requireNotEmpty(String underCheck) {
        if (MoreStrings.isEmpty(underCheck)) {
            throw new IllegalArgumentException("Given String is Empty");
        }
        return underCheck;
    }

    public static String requireNotEmpty(String underCheck, String attributeName) {
        if (MoreStrings.isEmpty(underCheck)) {
            throw new IllegalArgumentException("Attribute with name '" + attributeName + "' must not be empty");
        }
        return underCheck;
    }

    public static String requireNotEmptyTrimmed(String underCheck) {
        if (MoreStrings.isBlank(underCheck)) {
            throw new IllegalArgumentException("Attribute must not be blank");
        }
        return underCheck;
    }

    public static String requireNotEmptyTrimmed(String underCheck, String attributeName) {
        if (MoreStrings.isBlank(underCheck)) {
            throw new IllegalArgumentException("Attribute with name '" + attributeName + "' must not be blank");
        }
        return underCheck;
    }

    @NonNull
    public static String nullToEmpty(String string) {
        if (null == string) {
            return EMPTY;
        }
        return string;
    }

    public static String emptyToNull(String string) {
        if (null == string || string.isEmpty()) {
            return null;
        }
        return string;
    }

    public static String trimOrNull(String string) {
        return null != string ? string.trim() : null;
    }

    @NonNull
    public static String lenientFormat(String template, Object ... args) {
        int placeholderStart;
        ArrayList<String> lenientArgs;
        String templateString = String.valueOf(template);
        if (args == null) {
            lenientArgs = new ArrayList<String>(1);
            lenientArgs.add("(Object[])null");
        } else {
            lenientArgs = new ArrayList(args.length);
            for (Object arg : args) {
                lenientArgs.add(MoreStrings.lenientToString(arg));
            }
        }
        StringBuilder builder = new StringBuilder(templateString.length() + 16 * lenientArgs.size());
        int templateStart = 0;
        int i = 0;
        while (i < lenientArgs.size() && (placeholderStart = templateString.indexOf("%s", templateStart)) != -1) {
            builder.append(templateString, templateStart, placeholderStart);
            builder.append(lenientArgs.get(i++));
            templateStart = placeholderStart + 2;
        }
        builder.append(templateString, templateStart, templateString.length());
        if (i < lenientArgs.size()) {
            builder.append(" [");
            builder.append(lenientArgs.get(i++));
            while (i < lenientArgs.size()) {
                builder.append(", ");
                builder.append(lenientArgs.get(i++));
            }
            builder.append(']');
        }
        LOGGER.log(Level.FINE, () -> "No args given, returning template " + templateString);
        return builder.toString();
    }

    public static String ensureEndsWith(@NonNull String value, @NonNull String suffix) {
        Objects.requireNonNull(value, "value must not be null");
        Objects.requireNonNull(suffix, "suffix must not be null");
        if (!value.endsWith(suffix)) {
            return value + suffix;
        }
        return value;
    }

    static String lenientToString(Object o) {
        try {
            if (o != null && o.getClass().isArray()) {
                Object object = o;
                Objects.requireNonNull(object);
                Object object2 = object;
                int n = 0;
                return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Object[].class, int[].class, long[].class, double[].class, float[].class, boolean[].class, byte[].class, short[].class, char[].class}, (Object)object2, n)) {
                    case 0 -> {
                        Object[] arr = (Object[])object2;
                        yield Arrays.toString(arr);
                    }
                    case 1 -> {
                        int[] arr = (int[])object2;
                        yield Arrays.toString(arr);
                    }
                    case 2 -> {
                        long[] arr = (long[])object2;
                        yield Arrays.toString(arr);
                    }
                    case 3 -> {
                        double[] arr = (double[])object2;
                        yield Arrays.toString(arr);
                    }
                    case 4 -> {
                        float[] arr = (float[])object2;
                        yield Arrays.toString(arr);
                    }
                    case 5 -> {
                        boolean[] arr = (boolean[])object2;
                        yield Arrays.toString(arr);
                    }
                    case 6 -> {
                        byte[] arr = (byte[])object2;
                        yield Arrays.toString(arr);
                    }
                    case 7 -> {
                        short[] arr = (short[])object2;
                        yield Arrays.toString(arr);
                    }
                    case 8 -> {
                        char[] arr = (char[])object2;
                        yield Arrays.toString(arr);
                    }
                    default -> String.valueOf(o);
                };
            }
            return String.valueOf(o);
        }
        catch (RuntimeException e) {
            String objectToString = o == null ? "null" : o.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(o));
            LOGGER.log(Level.WARNING, e, () -> "Exception during lenientFormat for " + objectToString);
            return "<" + objectToString + " threw " + e.getClass().getName() + ">";
        }
    }

    @NonNull
    public static Optional<String> coalesce(Predicate<String> checker, String ... values) {
        Objects.requireNonNull(checker, "checker must not be null");
        if (null != values) {
            for (String value : values) {
                if (checker.test(value)) continue;
                return Optional.of(value);
            }
        }
        return Optional.empty();
    }

    @NonNull
    public static Optional<String> firstNonEmpty(String ... values) {
        return MoreStrings.coalesce(MoreStrings::isEmpty, values);
    }

    @NonNull
    public static Optional<String> firstNonBlank(String ... values) {
        return MoreStrings.coalesce(MoreStrings::isBlank, values);
    }

    @Generated
    private MoreStrings() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

