/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.collect;

import de.cuioss.tools.base.Preconditions;
import de.cuioss.tools.collect.MapDiffenceImpl;
import de.cuioss.tools.collect.MapDifference;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;

public final class MoreCollections {
    public static boolean isEmpty(Object ... elements) {
        return Objects.isNull(elements) || elements.length == 0;
    }

    public static boolean isEmpty(Iterable<?> elements) {
        return Optional.ofNullable(elements).map(it -> !it.iterator().hasNext()).orElse(true);
    }

    public static boolean isEmpty(Collection<?> elements) {
        return Optional.ofNullable(elements).map(Collection::isEmpty).orElse(true);
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return Optional.ofNullable(map).map(Map::isEmpty).orElse(true);
    }

    public static boolean isEmpty(Iterator<?> elements) {
        return Optional.ofNullable(elements).map(it -> !it.hasNext()).orElse(true);
    }

    @SafeVarargs
    public static <T> T[] requireNotEmpty(T ... elements) {
        Preconditions.checkArgument(!MoreCollections.isEmpty(elements));
        return elements;
    }

    public static <T> Collection<T> requireNotEmpty(Collection<T> elements) {
        Preconditions.checkArgument(!MoreCollections.isEmpty(elements));
        return elements;
    }

    public static <T> Collection<T> requireNotEmpty(Collection<T> elements, String message) {
        Preconditions.checkArgument(!MoreCollections.isEmpty(elements), message);
        return elements;
    }

    public static <K, V> Map<K, V> requireNotEmpty(Map<K, V> elements) {
        Preconditions.checkArgument(!MoreCollections.isEmpty(elements));
        return elements;
    }

    public static <K, V> Map<K, V> requireNotEmpty(Map<K, V> elements, String message) {
        Preconditions.checkArgument(!MoreCollections.isEmpty(elements), message);
        return elements;
    }

    public static <T> Iterable<T> requireNotEmpty(Iterable<T> elements) {
        Preconditions.checkArgument(!MoreCollections.isEmpty(elements));
        return elements;
    }

    public static <T> Iterable<T> requireNotEmpty(Iterable<T> elements, String message) {
        Preconditions.checkArgument(!MoreCollections.isEmpty(elements), message);
        return elements;
    }

    public static <T> Iterator<T> requireNotEmpty(Iterator<T> elements) {
        Preconditions.checkArgument(!MoreCollections.isEmpty(elements));
        return elements;
    }

    public static <T> Iterator<T> requireNotEmpty(Iterator<T> elements, String message) {
        Preconditions.checkArgument(!MoreCollections.isEmpty(elements), message);
        return elements;
    }

    public static <T> Stream<T> requireNotEmpty(Stream<T> elements) {
        Preconditions.checkArgument(!MoreCollections.isEmpty(elements));
        return elements;
    }

    public static <T> Stream<T> requireNotEmpty(Stream<T> elements, String message) {
        Preconditions.checkArgument(!MoreCollections.isEmpty(elements), message);
        return elements;
    }

    public static boolean isEmpty(Stream<?> elements) {
        return Objects.isNull(elements);
    }

    public static boolean containsKey(Map<?, ?> map, Object ... keys) {
        if (MoreCollections.isEmpty(map) || MoreCollections.isEmpty(keys)) {
            return false;
        }
        for (Object key : keys) {
            if (!map.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public static <K, V> MapDifference<K, V> difference(Map<? extends K, ? extends V> left, Map<? extends K, ? extends V> right) {
        return MapDiffenceImpl.from(left, right);
    }

    @Generated
    private MoreCollections() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

