/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.concurrent;

import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public record RingBufferStatistics(int sampleCount, Duration p50, Duration p95, Duration p99) {
    public RingBufferStatistics {
        if (sampleCount < 0) {
            throw new IllegalArgumentException("Sample count cannot be negative: " + sampleCount);
        }
    }

    public static RingBufferStatistics computeFrom(long[] samples, TimeUnit timeUnit) {
        if (samples == null || samples.length == 0) {
            return new RingBufferStatistics(0, Duration.ZERO, Duration.ZERO, Duration.ZERO);
        }
        Arrays.sort(samples);
        long medianValue = RingBufferStatistics.calculatePercentile(samples, 0.5);
        long p95Value = RingBufferStatistics.calculatePercentile(samples, 0.95);
        long p99Value = RingBufferStatistics.calculatePercentile(samples, 0.99);
        Duration p50 = Duration.of(medianValue, timeUnit.toChronoUnit());
        Duration p95 = Duration.of(p95Value, timeUnit.toChronoUnit());
        Duration p99 = Duration.of(p99Value, timeUnit.toChronoUnit());
        return new RingBufferStatistics(samples.length, p50, p95, p99);
    }

    private static long calculatePercentile(long[] sortedSamples, double percentile) {
        if (sortedSamples.length == 0) {
            return 0L;
        }
        if (Math.abs(percentile - 0.5) < 1.0E-9 && sortedSamples.length % 2 == 0) {
            int lowerIndex = sortedSamples.length / 2 - 1;
            int upperIndex = sortedSamples.length / 2;
            return (sortedSamples[lowerIndex] + sortedSamples[upperIndex]) / 2L;
        }
        int index = (int)Math.ceil(percentile * (double)sortedSamples.length) - 1;
        index = Math.clamp((long)index, 0, sortedSamples.length - 1);
        return sortedSamples[index];
    }
}

