/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.concurrent;

import de.cuioss.tools.concurrent.RingBuffer;
import de.cuioss.tools.concurrent.RingBufferStatistics;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public record StripedRingBufferStatistics(int sampleCount, Duration p50, Duration p95, Duration p99) {
    static StripedRingBufferStatistics computeFrom(RingBuffer[] stripes, TimeUnit timeUnit) {
        int totalCount = 0;
        long[][] stripeSnapshots = new long[stripes.length][];
        for (int i = 0; i < stripes.length; ++i) {
            stripeSnapshots[i] = stripes[i].getSamplesSnapshot();
            totalCount += stripeSnapshots[i].length;
        }
        if (totalCount == 0) {
            return new StripedRingBufferStatistics(0, Duration.ZERO, Duration.ZERO, Duration.ZERO);
        }
        long[] allSamples = new long[totalCount];
        int offset = 0;
        for (long[] stripeSamples : stripeSnapshots) {
            if (stripeSamples.length <= 0) continue;
            System.arraycopy(stripeSamples, 0, allSamples, offset, stripeSamples.length);
            offset += stripeSamples.length;
        }
        RingBufferStatistics aggregatedStats = RingBufferStatistics.computeFrom(allSamples, timeUnit);
        return new StripedRingBufferStatistics(aggregatedStats.sampleCount(), aggregatedStats.p50(), aggregatedStats.p95(), aggregatedStats.p99());
    }
}

