/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.lang;

import de.cuioss.tools.base.Preconditions;
import java.util.Locale;
import lombok.Generated;

public final class LocaleUtils {
    private static final String INVALID_LOCALE_FORMAT = "Invalid locale format: ";

    public static Locale toLocale(String str) {
        if (null == str) {
            return null;
        }
        return LocaleUtils.toLocaleInternal(str);
    }

    private static Locale toLocaleInternal(String str) {
        if (str.isEmpty()) {
            return new Locale.Builder().setLanguage("").setRegion("").build();
        }
        Preconditions.checkArgument(!str.contains("#"), INVALID_LOCALE_FORMAT + str);
        if (str.startsWith("_")) {
            return LocaleUtils.handleUnderscorePrefixedLocale(str);
        }
        if (!str.contains("_")) {
            return LocaleUtils.handleSimpleLocale(str);
        }
        String[] parts = str.split("_", 3);
        return switch (parts.length) {
            case 1 -> LocaleUtils.handleSinglePart(parts[0]);
            case 2 -> LocaleUtils.handleTwoParts(parts[0], parts[1]);
            case 3 -> LocaleUtils.handleThreeParts(str, parts);
            default -> throw new IllegalArgumentException(INVALID_LOCALE_FORMAT + str);
        };
    }

    private static Locale handleUnderscorePrefixedLocale(String str) {
        Preconditions.checkArgument(str.length() >= 3, "Must be at least 3 chars if starts with underscore");
        Preconditions.checkArgument(str.length() < 5 || str.startsWith("_", 3), "Must have underscore after the country if starts with underscore and is at least 5 chars");
        Preconditions.checkArgument(str.length() != 4, "Must be at least 5 chars if starts with underscore");
        String[] parts = str.split("_", 3);
        if (parts.length == 2) {
            LocaleUtils.validateCountryCode(parts[1]);
            return new Locale.Builder().setLanguage("").setRegion(parts[1]).build();
        }
        if (parts.length == 3) {
            LocaleUtils.validateCountryCode(parts[1]);
            return new Locale.Builder().setLanguage("").setRegion(parts[1]).setVariant(parts[2]).build();
        }
        throw new IllegalArgumentException(INVALID_LOCALE_FORMAT + str);
    }

    private static Locale handleSimpleLocale(String str) {
        Preconditions.checkArgument(str.length() == 2 || str.length() == 3, "Must be 2 chars if less than 5");
        Preconditions.checkArgument(str.equals(str.toLowerCase()), INVALID_LOCALE_FORMAT + str);
        return new Locale.Builder().setLanguage(str).build();
    }

    private static Locale handleSinglePart(String language) {
        return new Locale.Builder().setLanguage(language.toLowerCase()).build();
    }

    private static Locale handleTwoParts(String language, String country) {
        LocaleUtils.validateLanguageCode(language);
        if (country.matches("\\d{3}")) {
            return new Locale.Builder().setLanguage(language).setRegion(country).build();
        }
        LocaleUtils.validateCountryCode(country);
        if (language.isEmpty()) {
            return new Locale.Builder().setLanguage("").setRegion(country).build();
        }
        return new Locale.Builder().setLanguage(language).setRegion(country).build();
    }

    private static Locale handleThreeParts(String str, String[] parts) {
        Preconditions.checkArgument(str.length() == 3 || str.length() == 5 || str.length() >= 7, "Must be 3, 5 or 7+ in length");
        LocaleUtils.validateLanguageCode(parts[0]);
        Locale.Builder builder = new Locale.Builder().setLanguage(parts[0]);
        if (parts[1].isEmpty() && !parts[2].isEmpty()) {
            LocaleUtils.validateVariant(parts[2]);
            return builder.setVariant(parts[2]).build();
        }
        if (parts[1].matches("\\d{3}")) {
            LocaleUtils.validateVariant(parts[2]);
            return builder.setRegion(parts[1]).setVariant(parts[2]).build();
        }
        LocaleUtils.validateCountryCode(parts[1]);
        LocaleUtils.validateVariant(parts[2]);
        return builder.setRegion(parts[1]).setVariant(parts[2]).build();
    }

    private static void validateLanguageCode(String language) {
        Preconditions.checkArgument(language.equals(language.toLowerCase()), "Language code must be lowercase");
    }

    private static void validateCountryCode(String country) {
        Preconditions.checkArgument(country.equals(country.toUpperCase()) && country.matches("[A-Z]{2}"), "Country code must be uppercase");
    }

    private static void validateVariant(String variant) {
        Preconditions.checkArgument(variant.matches("[A-Za-z0-9]{5,8}(_[A-Za-z0-9]{5,8})*"), "Variant must be 5-8 alphanumeric characters or sequence of such strings separated by underscore");
    }

    @Generated
    private LocaleUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

