/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.logging;

import de.cuioss.tools.logging.LogLevel;
import de.cuioss.tools.logging.LogRecord;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class CuiLogger {
    private final Logger delegate;
    static final Pattern SLF4J_PATTERN = Pattern.compile(Pattern.quote("{}"));

    public CuiLogger(Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz must not be null");
        this.delegate = Logger.getLogger(clazz.getName());
    }

    public CuiLogger(String name) {
        Objects.requireNonNull(name, "name must not be null");
        this.delegate = Logger.getLogger(name);
    }

    public boolean isTraceEnabled() {
        return LogLevel.TRACE.isEnabled(this.delegate);
    }

    public void trace(String msg) {
        LogLevel.TRACE.handleActualLog(this.delegate, msg, null);
    }

    public void trace(Supplier<String> msg) {
        LogLevel.TRACE.log(this.delegate, msg, null);
    }

    public void trace(Throwable throwable, Supplier<String> msg) {
        LogLevel.TRACE.log(this.delegate, msg, throwable);
    }

    public void trace(String msg, Throwable throwable) {
        LogLevel.TRACE.handleActualLog(this.delegate, msg, throwable);
    }

    public void trace(Throwable throwable, String template, Object ... parameter) {
        LogLevel.TRACE.log(this.delegate, throwable, template, parameter);
    }

    public void trace(String template, Object ... parameter) {
        LogLevel.TRACE.log(this.delegate, template, parameter);
    }

    public void trace(Throwable throwable, String msg) {
        LogLevel.TRACE.handleActualLog(this.delegate, msg, throwable);
    }

    public boolean isDebugEnabled() {
        return LogLevel.DEBUG.isEnabled(this.delegate);
    }

    public void debug(String msg) {
        LogLevel.DEBUG.handleActualLog(this.delegate, msg, null);
    }

    public void debug(String msg, Throwable throwable) {
        LogLevel.DEBUG.handleActualLog(this.delegate, msg, throwable);
    }

    public void debug(Supplier<String> msg) {
        LogLevel.DEBUG.log(this.delegate, msg, null);
    }

    public void debug(Throwable throwable, Supplier<String> msg) {
        LogLevel.DEBUG.log(this.delegate, msg, throwable);
    }

    public void debug(Throwable throwable, String template, Object ... parameter) {
        LogLevel.DEBUG.log(this.delegate, throwable, template, parameter);
    }

    public void debug(String template, Object ... parameter) {
        LogLevel.DEBUG.log(this.delegate, template, parameter);
    }

    public void debug(Throwable throwable, String msg) {
        LogLevel.DEBUG.handleActualLog(this.delegate, msg, throwable);
    }

    public boolean isInfoEnabled() {
        return LogLevel.INFO.isEnabled(this.delegate);
    }

    public void info(String msg) {
        LogLevel.INFO.handleActualLog(this.delegate, msg, null);
    }

    public void info(String msg, Throwable throwable) {
        LogLevel.INFO.handleActualLog(this.delegate, msg, throwable);
    }

    public void info(Supplier<String> msg) {
        LogLevel.INFO.log(this.delegate, msg, null);
    }

    public void info(Throwable throwable, Supplier<String> msg) {
        LogLevel.INFO.log(this.delegate, msg, throwable);
    }

    public void info(Throwable throwable, String template, Object ... parameter) {
        LogLevel.INFO.log(this.delegate, throwable, template, parameter);
    }

    public void info(String template, Object ... parameter) {
        LogLevel.INFO.log(this.delegate, template, parameter);
    }

    public void info(Throwable throwable, String msg) {
        LogLevel.INFO.handleActualLog(this.delegate, msg, throwable);
    }

    public void info(LogRecord template) {
        LogLevel.INFO.log(this.delegate, template);
    }

    public void info(LogRecord template, Object ... parameter) {
        LogLevel.INFO.log(this.delegate, template, parameter);
    }

    public void info(Throwable throwable, LogRecord template) {
        LogLevel.INFO.log(this.delegate, throwable, template);
    }

    public void info(Throwable throwable, LogRecord template, Object ... parameter) {
        LogLevel.INFO.log(this.delegate, throwable, template, parameter);
    }

    public boolean isWarnEnabled() {
        return LogLevel.WARN.isEnabled(this.delegate);
    }

    public void warn(String msg) {
        LogLevel.WARN.handleActualLog(this.delegate, msg, null);
    }

    public void warn(String msg, Throwable throwable) {
        LogLevel.WARN.handleActualLog(this.delegate, msg, throwable);
    }

    public void warn(Supplier<String> msg) {
        LogLevel.WARN.log(this.delegate, msg, null);
    }

    public void warn(Throwable throwable, Supplier<String> msg) {
        LogLevel.WARN.log(this.delegate, msg, throwable);
    }

    public void warn(Throwable throwable, String template, Object ... parameter) {
        LogLevel.WARN.log(this.delegate, throwable, template, parameter);
    }

    public void warn(String template, Object ... parameter) {
        LogLevel.WARN.log(this.delegate, template, parameter);
    }

    public void warn(Throwable throwable, String msg) {
        LogLevel.WARN.handleActualLog(this.delegate, msg, throwable);
    }

    public void warn(LogRecord template) {
        LogLevel.WARN.log(this.delegate, template);
    }

    public void warn(LogRecord template, Object ... parameter) {
        LogLevel.WARN.log(this.delegate, template, parameter);
    }

    public void warn(Throwable throwable, LogRecord template) {
        LogLevel.WARN.log(this.delegate, throwable, template);
    }

    public void warn(Throwable throwable, LogRecord template, Object ... parameter) {
        LogLevel.WARN.log(this.delegate, throwable, template, parameter);
    }

    public boolean isErrorEnabled() {
        return LogLevel.ERROR.isEnabled(this.delegate);
    }

    public void error(String msg) {
        LogLevel.ERROR.handleActualLog(this.delegate, msg, null);
    }

    public void error(String msg, Throwable throwable) {
        LogLevel.ERROR.handleActualLog(this.delegate, msg, throwable);
    }

    public void error(Supplier<String> msg) {
        LogLevel.ERROR.log(this.delegate, msg, null);
    }

    public void error(Throwable throwable, Supplier<String> msg) {
        LogLevel.ERROR.log(this.delegate, msg, throwable);
    }

    public void error(Throwable throwable, String template, Object ... parameter) {
        LogLevel.ERROR.log(this.delegate, throwable, template, parameter);
    }

    public void error(String template, Object ... parameter) {
        LogLevel.ERROR.log(this.delegate, template, parameter);
    }

    public void error(Throwable throwable, String msg) {
        LogLevel.ERROR.handleActualLog(this.delegate, msg, throwable);
    }

    public void error(LogRecord template) {
        LogLevel.ERROR.log(this.delegate, template);
    }

    public void error(LogRecord template, Object ... parameter) {
        LogLevel.ERROR.log(this.delegate, template, parameter);
    }

    public void error(Throwable throwable, LogRecord template) {
        LogLevel.ERROR.log(this.delegate, throwable, template);
    }

    public void error(Throwable throwable, LogRecord template, Object ... parameter) {
        LogLevel.ERROR.log(this.delegate, throwable, template, parameter);
    }

    Logger getWrapped() {
        return this.delegate;
    }

    public String getName() {
        return this.delegate.getName();
    }

    public LogLevel getLogLevel() {
        return LogLevel.from(this.delegate.getLevel());
    }
}

