/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.logging;

import de.cuioss.tools.collect.CollectionLiterals;
import de.cuioss.tools.logging.CuiLogger;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import lombok.Generated;

public final class CuiLoggerFactory {
    static final Set<String> MARKER_CLASS_NAMES = CollectionLiterals.immutableSet(CuiLogger.class.getName(), CuiLoggerFactory.class.getName());
    private static final Supplier<IllegalStateException> ILLEGAL_STATE_EXCEPTION_SUPPLIER = () -> new IllegalStateException("Unable to detect caller class name. Make sure '" + String.valueOf(MARKER_CLASS_NAMES) + "' was used for creation.");

    public static CuiLogger getLogger() {
        return CuiLoggerFactory.getLogger(CuiLoggerFactory.findCallerInternal(MARKER_CLASS_NAMES).orElseThrow(ILLEGAL_STATE_EXCEPTION_SUPPLIER));
    }

    public static CuiLogger getLogger(String className) {
        return new CuiLogger(className);
    }

    public static CuiLogger getLogger(Class<?> clazz) {
        return new CuiLogger(clazz);
    }

    private static Optional<String> findCallerInternal(Collection<String> markerClasses) {
        Objects.requireNonNull(markerClasses, "Marker class names are missing");
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        if (null == stackTraceElements || stackTraceElements.length < 5) {
            return Optional.empty();
        }
        for (int index = 2; index < stackTraceElements.length; ++index) {
            StackTraceElement element = stackTraceElements[index];
            if (!markerClasses.contains(element.getClassName())) continue;
            if (stackTraceElements.length > index + 1) {
                return Optional.of(stackTraceElements[index + 1].getClassName());
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    @Generated
    private CuiLoggerFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

