/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.tools.logging;

import de.cuioss.tools.collect.CollectionLiterals;
import de.cuioss.tools.logging.CuiLogger;
import de.cuioss.tools.logging.CuiLoggerFactory;
import de.cuioss.tools.logging.LogRecord;
import de.cuioss.tools.reflect.MoreReflection;
import de.cuioss.tools.string.MoreStrings;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public enum LogLevel {
    TRACE(Level.FINER),
    DEBUG(Level.FINE),
    INFO(Level.INFO),
    WARN(Level.WARNING),
    ERROR(Level.SEVERE),
    OFF(Level.OFF);

    private final Level juliLevel;

    boolean isEnabled(Logger logger) {
        return logger.isLoggable(this.getJuliLevel());
    }

    void handleActualLog(Logger logger, String message, @Nullable Throwable throwable) {
        if (!this.isEnabled(logger)) {
            return;
        }
        this.doLog(logger, message, throwable);
    }

    public static LogLevel from(Level juliLevel) {
        List<LogLevel[]> sortedCuiLevels = CollectionLiterals.mutableList(LogLevel.values());
        sortedCuiLevels.sort(Comparator.comparing(logLevel -> logLevel.getJuliLevel().intValue()));
        sortedCuiLevels.sort(Comparator.reverseOrder());
        int juliIntLevel = juliLevel.intValue();
        for (LogLevel logLevel2 : sortedCuiLevels) {
            int cuiIntLevel = logLevel2.getJuliLevel().intValue();
            if (cuiIntLevel > juliIntLevel) continue;
            return logLevel2;
        }
        return TRACE;
    }

    private void doLog(Logger logger, String message, @Nullable Throwable throwable) {
        Optional<StackTraceElement> caller = MoreReflection.findCallerElement(throwable, CuiLoggerFactory.MARKER_CLASS_NAMES);
        if (caller.isPresent()) {
            logger.logp(this.getJuliLevel(), caller.get().getClassName(), caller.get().getMethodName(), message, throwable);
        } else {
            logger.log(this.getJuliLevel(), message, throwable);
        }
    }

    void log(Logger logger, String template, Object ... parameter) {
        if (this.isEnabled(logger)) {
            String replacedTemplate = CuiLogger.SLF4J_PATTERN.matcher(MoreStrings.nullToEmpty(template)).replaceAll("%s");
            this.doLog(logger, MoreStrings.lenientFormat(replacedTemplate, parameter), null);
        }
    }

    void log(Logger logger, Supplier<String> message, @Nullable Throwable throwable) {
        if (this.isEnabled(logger)) {
            this.doLog(logger, message.get(), throwable);
        }
    }

    void log(Logger logger, @Nullable Throwable throwable, String template, Object ... parameter) {
        if (this.isEnabled(logger)) {
            String replacedTemplate = CuiLogger.SLF4J_PATTERN.matcher(MoreStrings.nullToEmpty(template)).replaceAll("%s");
            this.doLog(logger, MoreStrings.lenientFormat(replacedTemplate, parameter), throwable);
        }
    }

    void log(Logger logger, LogRecord template, Object ... parameter) {
        if (this.isEnabled(logger)) {
            this.doLog(logger, template.format(parameter), null);
        }
    }

    void log(Logger logger, LogRecord template) {
        if (this.isEnabled(logger)) {
            this.doLog(logger, template.format(new Object[0]), null);
        }
    }

    void log(Logger logger, @Nullable Throwable throwable, LogRecord template, Object ... parameter) {
        if (this.isEnabled(logger)) {
            this.doLog(logger, template.format(parameter), throwable);
        }
    }

    void log(Logger logger, @Nullable Throwable throwable, LogRecord template) {
        if (this.isEnabled(logger)) {
            this.doLog(logger, template.format(new Object[0]), throwable);
        }
    }

    @Generated
    private LogLevel(Level juliLevel) {
        this.juliLevel = juliLevel;
    }

    @Generated
    Level getJuliLevel() {
        return this.juliLevel;
    }
}

