/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.generator.internal.net.java.quickcheck.generator.support;

import de.cuioss.test.generator.internal.net.java.quickcheck.Generator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.LongGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.VetoableGenerator;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class DateGenerator
implements Generator<Date> {
    private final VetoableGenerator<Long> generator;

    public DateGenerator(TimeUnit precision, long low, long high, int tries) {
        this.generator = new VetoableGenerator<Long>((Generator)new MillisGenerator(precision, low, high), tries){

            @Override
            protected boolean tryValue(Long value) {
                return value != null;
            }
        };
    }

    @Override
    public Date next() {
        return new Date(this.generator.next());
    }

    private static class MillisGenerator
    implements Generator<Long> {
        private final TimeUnit precision;
        private final LongGenerator times;
        private final long low;
        private final long high;

        public MillisGenerator(TimeUnit precision, long low, long high) {
            this.precision = precision;
            this.times = new LongGenerator(low, high);
            this.low = low;
            this.high = high;
        }

        @Override
        public Long next() {
            Long millis = this.times.next();
            Calendar time = Calendar.getInstance();
            time.setTimeInMillis(millis);
            switch (this.precision) {
                case DAYS: {
                    time.set(10, 0);
                }
                case HOURS: {
                    time.set(12, 0);
                }
                case MINUTES: {
                    time.set(13, 0);
                }
                case SECONDS: {
                    time.set(14, 0);
                }
            }
            long correctedMillis = time.getTimeInMillis();
            return this.isOutOffBounds(correctedMillis) || this.isOverflow(millis, correctedMillis) ? null : Long.valueOf(correctedMillis);
        }

        private boolean isOutOffBounds(long correctedMillis) {
            return correctedMillis < this.low || correctedMillis > this.high;
        }

        private boolean isOverflow(long millis, long correctedMillis) {
            return Math.signum(correctedMillis) != Math.signum(millis);
        }

        public String toString() {
            return String.format("%s[low=%s, high=%s, precision=%s", new Object[]{this.getClass().getSimpleName(), this.low, this.high, this.precision});
        }
    }
}

