/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.generator.internal.net.java.quickcheck.generator.support;

import de.cuioss.test.generator.internal.net.java.quickcheck.Generator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.IntegerGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ListGenerator<T>
implements Generator<List<T>> {
    public static final int MIN_SIZE = 0;
    public static final int MAX_SIZE = 10;
    private final Generator<? extends T> content;
    private final Generator<Integer> size;

    public ListGenerator(Generator<? extends T> content) {
        this(content, 0, 10);
    }

    public ListGenerator(Generator<? extends T> content, int min, int max) {
        this(content, new IntegerGenerator(min, max));
    }

    public ListGenerator(Generator<? extends T> content, Generator<Integer> size) {
        Objects.requireNonNull(content, "content");
        Objects.requireNonNull(size, "size");
        this.content = content;
        this.size = size;
    }

    @Override
    public List<T> next() {
        int size = Math.max(0, this.size.next());
        ArrayList<T> list = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            list.add(this.content.next());
        }
        return list;
    }
}

