/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.generator.internal.net.java.quickcheck.generator.support;

import de.cuioss.test.generator.internal.net.java.quickcheck.Generator;
import de.cuioss.test.generator.internal.net.java.quickcheck.StatefulGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.IntegerGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.ListGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.UniqueValuesGenerator;
import java.util.HashSet;
import java.util.Set;

public class SetGenerator<T>
implements Generator<Set<T>> {
    public static final int MAX_SIZE = 10;
    public static final int MAX_TRIES = 100;
    private final ListGenerator<T> lists;
    private final StatefulGenerator<T> content;

    public SetGenerator(Generator<? extends T> content) {
        this(content, 100);
    }

    public SetGenerator(Generator<? extends T> content, int tries) {
        this(content, new IntegerGenerator(0, 10), tries);
    }

    public SetGenerator(Generator<? extends T> content, Generator<Integer> size, int tries) {
        this.content = new UniqueValuesGenerator<T>(content, tries);
        this.lists = new ListGenerator<T>(this.content, size);
    }

    @Override
    public Set<T> next() {
        this.content.reset();
        return new HashSet(this.lists.next());
    }
}

