/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.generator.junit;

import de.cuioss.test.generator.internal.net.java.quickcheck.generator.distribution.RandomConfiguration;
import de.cuioss.test.generator.junit.GeneratorSeed;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.opentest4j.AssertionFailedError;
import org.opentest4j.TestAbortedException;

public class GeneratorControllerExtension
implements BeforeEachCallback,
TestExecutionExceptionHandler {
    private static final String MSG_TEMPLATE = "%s\nGeneratorController seed was %sL. \nUse a fixed seed by applying @GeneratorSeed(%sL) for the method/class, \nor by using the system property '-Dde.cuioss.test.generator.seed=%s'\n";

    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        if (throwable instanceof TestAbortedException) {
            throw throwable;
        }
        if (throwable instanceof AssertionFailedError) {
            AssertionFailedError failure = new AssertionFailedError(this.createErrorMessage(throwable, RandomConfiguration.getLastSeed()));
            failure.setStackTrace(throwable.getStackTrace());
            throw failure;
        }
        AssertionFailedError failure = new AssertionFailedError(throwable.getClass() + ": " + this.createErrorMessage(throwable, RandomConfiguration.getLastSeed()));
        failure.setStackTrace(throwable.getStackTrace());
        throw failure;
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        boolean seedSetByAnnotation = false;
        long initialSeed = -1L;
        if (context.getElement().isPresent()) {
            AnnotatedElement annotatedElement = (AnnotatedElement)context.getElement().get();
            GeneratorSeed seedAnnotation = annotatedElement.getAnnotation(GeneratorSeed.class);
            if (null == seedAnnotation && annotatedElement instanceof Method) {
                Method method = (Method)annotatedElement;
                seedAnnotation = method.getDeclaringClass().getAnnotation(GeneratorSeed.class);
            }
            if (null != seedAnnotation) {
                initialSeed = seedAnnotation.value();
                seedSetByAnnotation = true;
            }
        }
        if (seedSetByAnnotation) {
            RandomConfiguration.setSeed(initialSeed);
        } else {
            RandomConfiguration.initSeed();
        }
    }

    private String createErrorMessage(Throwable e, Long seed) {
        String causeMsg = e.getMessage() == null ? "" : e.getMessage();
        return MSG_TEMPLATE.formatted(causeMsg, seed, seed, seed);
    }
}

