/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.generator;

import de.cuioss.test.generator.TypedGenerator;
import de.cuioss.test.generator.impl.CollectionGenerator;
import de.cuioss.test.generator.impl.DecoratorGenerator;
import de.cuioss.test.generator.impl.FloatObjectGenerator;
import de.cuioss.test.generator.impl.LocalDateGenerator;
import de.cuioss.test.generator.impl.LocalDateTimeGenerator;
import de.cuioss.test.generator.impl.LocalTimeGenerator;
import de.cuioss.test.generator.impl.NonBlankStringGenerator;
import de.cuioss.test.generator.impl.NumberGenerator;
import de.cuioss.test.generator.impl.ShortObjectGenerator;
import de.cuioss.test.generator.impl.URLGenerator;
import de.cuioss.test.generator.impl.ZoneOffsetGenerator;
import de.cuioss.test.generator.impl.ZonedDateTimeGenerator;
import de.cuioss.test.generator.internal.net.QuickCheckGeneratorAdapter;
import de.cuioss.test.generator.internal.net.java.quickcheck.Generator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.CombinedGenerators;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.PrimitiveGenerators;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.FixedValuesGenerator;
import de.cuioss.tools.collect.CollectionLiterals;
import java.io.Serializable;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import lombok.Generated;

public final class Generators {
    public static <T> Optional<TypedGenerator<T>> enumValuesIfAvailable(Class<T> type) {
        if (null == type || !type.isEnum()) {
            return Optional.empty();
        }
        return Optional.of(new QuickCheckGeneratorAdapter<T>(type, PrimitiveGenerators.enumValues(type)));
    }

    public static <T extends Enum<T>> TypedGenerator<T> enumValues(Class<T> type) {
        Objects.requireNonNull(type);
        return new QuickCheckGeneratorAdapter<T>(type, PrimitiveGenerators.enumValues(type));
    }

    public static TypedGenerator<String> nonEmptyStrings() {
        return new QuickCheckGeneratorAdapter<String>(String.class, PrimitiveGenerators.nonEmptyStrings());
    }

    public static TypedGenerator<String> nonBlankStrings() {
        return new NonBlankStringGenerator();
    }

    public static TypedGenerator<String> strings(int minSize, int maxSize) {
        return new QuickCheckGeneratorAdapter<String>(String.class, PrimitiveGenerators.strings(minSize, maxSize));
    }

    public static TypedGenerator<String> strings(String chars, int minSize, int maxSize) {
        return new QuickCheckGeneratorAdapter<String>(String.class, PrimitiveGenerators.strings(chars, minSize, maxSize));
    }

    public static TypedGenerator<String> strings() {
        return new QuickCheckGeneratorAdapter<String>(String.class, PrimitiveGenerators.strings());
    }

    public static TypedGenerator<String> letterStrings(int minSize, int maxSize) {
        return new QuickCheckGeneratorAdapter<String>(String.class, PrimitiveGenerators.letterStrings(minSize, maxSize));
    }

    public static TypedGenerator<String> letterStrings() {
        return Generators.letterStrings(3, Generators.integers(3, 256).next());
    }

    @SafeVarargs
    public static <T> TypedGenerator<T> fixedValues(Class<T> type, T ... values) {
        return Generators.fixedValues(type, Arrays.asList(values));
    }

    @SafeVarargs
    public static <T> TypedGenerator<T> fixedValues(T ... values) {
        return Generators.fixedValues(Arrays.asList(values));
    }

    public static <T> TypedGenerator<T> fixedValues(Class<T> type, Iterable<T> values) {
        return new QuickCheckGeneratorAdapter<T>(type, new FixedValuesGenerator(CollectionLiterals.mutableList(values)));
    }

    public static <T> TypedGenerator<T> fixedValues(Iterable<T> values) {
        return Generators.fixedValues(Generators.determineSupertypeFromIterable(values), values);
    }

    public static <T> TypedGenerator<T> uniqueValues(TypedGenerator<T> source) {
        return new QuickCheckGeneratorAdapter(source.getClass(), CombinedGenerators.uniqueValues(Generators.unwrap(source)));
    }

    public static <T> CollectionGenerator<T> asCollectionGenerator(TypedGenerator<T> source) {
        return new CollectionGenerator<T>(source);
    }

    public static TypedGenerator<Boolean> booleans() {
        return new QuickCheckGeneratorAdapter<Boolean>(Boolean.TYPE, PrimitiveGenerators.booleans());
    }

    public static TypedGenerator<Boolean> booleanObjects() {
        return new QuickCheckGeneratorAdapter<Boolean>(Boolean.class, PrimitiveGenerators.booleans());
    }

    public static TypedGenerator<Byte> bytes() {
        return new QuickCheckGeneratorAdapter<Byte>(Byte.TYPE, PrimitiveGenerators.bytes());
    }

    public static TypedGenerator<Byte> byteObjects() {
        return new QuickCheckGeneratorAdapter<Byte>(Byte.class, PrimitiveGenerators.bytes());
    }

    public static TypedGenerator<Character> characters() {
        return new QuickCheckGeneratorAdapter<Character>(Character.TYPE, PrimitiveGenerators.characters());
    }

    public static TypedGenerator<Character> characterObjects() {
        return new QuickCheckGeneratorAdapter<Character>(Character.class, PrimitiveGenerators.characters());
    }

    public static TypedGenerator<Double> doubles() {
        return new QuickCheckGeneratorAdapter<Double>(Double.TYPE, PrimitiveGenerators.doubles());
    }

    public static TypedGenerator<Double> doubles(double low, double high) {
        return new QuickCheckGeneratorAdapter<Double>(Double.class, PrimitiveGenerators.doubles(low, high));
    }

    public static TypedGenerator<Double> doubleObjects() {
        return new QuickCheckGeneratorAdapter<Double>(Double.class, PrimitiveGenerators.doubles());
    }

    public static TypedGenerator<Float> floats() {
        return new DecoratorGenerator<Float>(Float.TYPE, Generators.floatObjects());
    }

    public static TypedGenerator<Float> floats(float low, float high) {
        return new FloatObjectGenerator(low, high);
    }

    public static TypedGenerator<Float> floatObjects() {
        return new FloatObjectGenerator();
    }

    public static TypedGenerator<Integer> integers() {
        return new QuickCheckGeneratorAdapter<Integer>(Integer.TYPE, PrimitiveGenerators.integers());
    }

    public static TypedGenerator<Integer> integers(int low, int high) {
        return new QuickCheckGeneratorAdapter<Integer>(Integer.class, PrimitiveGenerators.integers(low, high));
    }

    public static TypedGenerator<Integer> integerObjects() {
        return new QuickCheckGeneratorAdapter<Integer>(Integer.class, PrimitiveGenerators.integers());
    }

    public static TypedGenerator<Number> numbers() {
        return new NumberGenerator();
    }

    public static TypedGenerator<Short> shorts() {
        return new DecoratorGenerator<Short>(Short.TYPE, Generators.shortObjects());
    }

    public static TypedGenerator<Short> shortObjects() {
        return new ShortObjectGenerator();
    }

    public static TypedGenerator<Long> longs() {
        return new QuickCheckGeneratorAdapter<Long>(Long.TYPE, PrimitiveGenerators.longs());
    }

    public static TypedGenerator<Long> longs(long low, long high) {
        return new QuickCheckGeneratorAdapter<Long>(Long.TYPE, PrimitiveGenerators.longs(low, high));
    }

    public static TypedGenerator<Long> longObjects() {
        return new QuickCheckGeneratorAdapter<Long>(Long.class, PrimitiveGenerators.longs());
    }

    public static TypedGenerator<Date> dates() {
        return new QuickCheckGeneratorAdapter<Date>(Date.class, PrimitiveGenerators.dates());
    }

    public static TypedGenerator<LocalDate> localDates() {
        return new LocalDateGenerator();
    }

    public static TypedGenerator<LocalTime> localTimes() {
        return new LocalTimeGenerator();
    }

    public static TypedGenerator<LocalDateTime> localDateTimes() {
        return new LocalDateTimeGenerator();
    }

    public static TypedGenerator<ZonedDateTime> zonedDateTimes() {
        return new ZonedDateTimeGenerator();
    }

    public static TypedGenerator<TimeZone> timeZones() {
        ArrayList<TimeZone> timezones = new ArrayList<TimeZone>();
        for (String id : TimeZone.getAvailableIDs()) {
            timezones.add(TimeZone.getTimeZone(id));
        }
        return Generators.fixedValues(TimeZone.class, timezones);
    }

    public static TypedGenerator<ZoneId> zoneIds() {
        return Generators.fixedValues(ZoneId.class, ZoneId.getAvailableZoneIds().stream().map(ZoneId::of).toList());
    }

    public static TypedGenerator<ZoneOffset> zoneOffsets() {
        return new ZoneOffsetGenerator();
    }

    public static TypedGenerator<Temporal> temporals() {
        return new TypedGenerator<Temporal>(){

            @Override
            public Class<Temporal> getType() {
                return Temporal.class;
            }

            @Override
            public Temporal next() {
                return Generators.zonedDateTimes().next().toInstant();
            }
        };
    }

    public static TypedGenerator<Class> classTypes() {
        return Generators.fixedValues(Class.class, new Class[]{Integer.class, String.class, Boolean.class, Float.class});
    }

    public static TypedGenerator<Locale> locales() {
        return Generators.fixedValues(Locale.class, Locale.getAvailableLocales());
    }

    public static TypedGenerator<Serializable> serializables() {
        return new QuickCheckGeneratorAdapter<Serializable>(Serializable.class, PrimitiveGenerators.nonEmptyStrings());
    }

    public static TypedGenerator<RuntimeException> runtimeExceptions() {
        return Generators.fixedValues(RuntimeException.class, new RuntimeException[]{new RuntimeException(), new IllegalArgumentException(), new IllegalStateException(), new NullPointerException()});
    }

    public static TypedGenerator<Throwable> throwables() {
        return Generators.fixedValues(Throwable.class, new Throwable[]{new RuntimeException(), new IllegalArgumentException(), new IllegalStateException(), new NullPointerException()});
    }

    public static TypedGenerator<URL> urls() {
        return new URLGenerator();
    }

    static <T> Generator<T> unwrap(TypedGenerator<T> generator) {
        return generator::next;
    }

    private static <T> Class<T> determineSupertypeFromIterable(Iterable<T> iterable) {
        Objects.requireNonNull(iterable, "iterable must not be null");
        Iterator<T> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            return iterator.next().getClass();
        }
        throw new IllegalArgumentException("Must contain at least a single element");
    }

    @Generated
    private Generators() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

