/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.generator.junit.parameterized;

import de.cuioss.test.generator.TypedGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.distribution.RandomConfiguration;
import de.cuioss.test.generator.junit.GeneratorSeed;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.ReflectionUtils;

public abstract class AbstractTypedGeneratorArgumentsProvider
implements ArgumentsProvider {
    protected static final String IN_CLASS = "] in class [";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
        long previousSeed = RandomConfiguration.getLastSeed();
        long useSeed = this.determineSeed(context);
        if (useSeed != previousSeed) {
            RandomConfiguration.setSeed(useSeed);
        }
        try {
            Stream<? extends Arguments> stream = this.provideArgumentsForGenerators(context);
            return stream;
        }
        finally {
            if (useSeed != previousSeed) {
                RandomConfiguration.setSeed(previousSeed);
            }
        }
    }

    protected abstract Stream<? extends Arguments> provideArgumentsForGenerators(ExtensionContext var1);

    protected abstract long getSeed();

    protected abstract int getCount();

    protected List<Arguments> generateArguments(TypedGenerator<?> generator) {
        ArrayList<Arguments> arguments = new ArrayList<Arguments>();
        for (int i = 0; i < this.getCount(); ++i) {
            arguments.add(Arguments.of((Object[])new Object[]{generator.next()}));
        }
        return arguments;
    }

    protected long determineSeed(ExtensionContext context) {
        AnnotatedElement element;
        long seed = this.getSeed();
        if (seed != -1L) {
            return seed;
        }
        if (context.getElement().isPresent() && (element = (AnnotatedElement)context.getElement().get()) instanceof Method) {
            Method method = (Method)element;
            GeneratorSeed seedAnnotation = method.getAnnotation(GeneratorSeed.class);
            if (seedAnnotation != null) {
                return seedAnnotation.value();
            }
            GeneratorSeed classAnnotation = method.getDeclaringClass().getAnnotation(GeneratorSeed.class);
            if (classAnnotation != null) {
                return classAnnotation.value();
            }
        }
        return RandomConfiguration.getLastSeed();
    }

    protected TypedGenerator<?> createGeneratorInstance(Class<? extends TypedGenerator<?>> generatorClass) {
        Objects.requireNonNull(generatorClass, "Generator class must not be null");
        try {
            return (TypedGenerator)ReflectionUtils.newInstance(generatorClass, (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new JUnitException("Failed to create TypedGenerator instance for " + generatorClass.getName() + ". Make sure it has a public no-args constructor.", (Throwable)e);
        }
    }

    protected Optional<Method> findMethod(Class<?> clazz, String methodName) {
        return Arrays.stream(clazz.getDeclaredMethods()).filter(m -> m.getName().equals(methodName)).filter(m -> m.getParameterCount() == 0).filter(m -> TypedGenerator.class.isAssignableFrom(m.getReturnType())).findFirst();
    }
}

