/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.generator.junit.parameterized;

import de.cuioss.test.generator.TypedGenerator;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;

final class GeneratorMethodResolver {
    static final String IN_CLASS = "] in class [";

    private GeneratorMethodResolver() {
    }

    static TypedGenerator<?> getGenerator(String methodName, ExtensionContext context) {
        Objects.requireNonNull(methodName, "Method name must not be null");
        if (StringUtils.isBlank((String)methodName)) {
            throw new JUnitException("Method name must not be blank");
        }
        if (methodName.contains("#")) {
            return GeneratorMethodResolver.getGeneratorFromExternalClass(methodName);
        }
        Class testClass = context.getRequiredTestClass();
        Object testInstance = context.getTestInstance().orElse(null);
        Method method = GeneratorMethodResolver.findMethod(testClass, methodName).orElseThrow(() -> new JUnitException("Could not find method [" + methodName + IN_CLASS + testClass.getName() + "]"));
        try {
            if (ReflectionUtils.isStatic((Member)method)) {
                return (TypedGenerator)method.invoke(null, new Object[0]);
            }
            if (testInstance != null) {
                return (TypedGenerator)method.invoke(testInstance, new Object[0]);
            }
            throw new JUnitException("Cannot invoke instance method [" + methodName + "] without a test instance");
        }
        catch (Exception e) {
            throw new JUnitException("Failed to invoke method [" + methodName + "]", (Throwable)e);
        }
    }

    static TypedGenerator<?> getGeneratorFromExternalClass(String methodReference) {
        String[] parts = methodReference.split("#", 2);
        if (parts.length != 2) {
            throw new JUnitException("Method reference [" + methodReference + "] must be in format 'fully.qualified.ClassName#methodName'");
        }
        String className = parts[0];
        String localMethodName = parts[1];
        try {
            Class<?> clazz = Class.forName(className);
            Method method = GeneratorMethodResolver.findMethod(clazz, localMethodName).orElseThrow(() -> new JUnitException("Could not find method [" + localMethodName + IN_CLASS + className + "]"));
            if (!ReflectionUtils.isStatic((Member)method)) {
                throw new JUnitException("Method [" + localMethodName + "] in external class [" + className + "] must be static");
            }
            return (TypedGenerator)method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new JUnitException("Could not find class [" + className + "]", (Throwable)e);
        }
        catch (Exception e) {
            throw new JUnitException("Failed to invoke method [" + localMethodName + IN_CLASS + className + "]", (Throwable)e);
        }
    }

    static Optional<Method> findMethod(Class<?> clazz, String methodName) {
        return Arrays.stream(clazz.getDeclaredMethods()).filter(method -> method.getName().equals(methodName)).filter(method -> method.getParameterCount() == 0).filter(method -> TypedGenerator.class.isAssignableFrom(method.getReturnType())).findFirst();
    }
}

