/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.generator.domain;

import de.cuioss.test.generator.Generators;
import de.cuioss.test.generator.TypedGenerator;
import de.cuioss.test.generator.domain.NameGenerators;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EmailGenerator
implements TypedGenerator<String> {
    private static final Logger LOGGER = Logger.getLogger(EmailGenerator.class.getName());
    private final TypedGenerator<String> firstNames = NameGenerators.FIRSTNAMES_ANY_ENGLISH.generator();
    private final TypedGenerator<String> familyNames = NameGenerators.FAMILY_NAMES_ENGLISH.generator();
    private static final TypedGenerator<String> TLDS = Generators.fixedValues("de", "org", "com", "net");
    private static final TypedGenerator<String> DOMAINS = Generators.fixedValues("email", "mail", "cuioss", "message", "example", "hospital");

    @Override
    public String next() {
        return EmailGenerator.createEmail(this.firstNames.next(), this.familyNames.next());
    }

    public static String createEmail(String firstname, String lastname) {
        if (firstname == null || firstname.isBlank() || lastname == null || lastname.isBlank()) {
            LOGGER.log(Level.WARNING, "Invalid name components for email generation: firstname=''{0}'', lastname=''{1}''", new Object[]{firstname, lastname});
            return "invalid.email@example.com";
        }
        String tld = TLDS.next();
        String email = (firstname + "." + lastname + "@" + DOMAINS.next()).toLowerCase();
        String fullEmail = email + "." + tld;
        LOGGER.log(Level.FINE, "Generated email: {0}", fullEmail);
        return fullEmail;
    }
}

