/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.generator.internal.net.java.quickcheck.generator.support;

import de.cuioss.test.generator.internal.net.java.quickcheck.Generator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.distribution.Distribution;
import java.util.Objects;

public class DoubleGenerator
implements Generator<Double> {
    private final double min;
    private final double max;
    private final Distribution distribution;

    public DoubleGenerator() {
        this(Double.MIN_VALUE, Double.MAX_VALUE);
    }

    public DoubleGenerator(double min, double max) {
        this(min, max, Distribution.UNIFORM);
    }

    public DoubleGenerator(double min, double max, Distribution dist) {
        if (max < min) {
            throw new IllegalArgumentException("min");
        }
        Objects.requireNonNull(dist, "dist");
        this.min = min;
        this.max = max;
        this.distribution = dist;
    }

    @Override
    public Double next() {
        return this.nextDouble();
    }

    public double nextDouble() {
        return this.distribution.nextRandomNumber() * (this.max - this.min) + this.min;
    }

    public String toString() {
        return "%s[min=%s, max=%s, distribution=%s".formatted(this.getClass().getSimpleName(), this.min, this.max, this.distribution);
    }
}

