/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.generator.internal.net.java.quickcheck.generator.support;

import de.cuioss.test.generator.internal.net.java.quickcheck.Generator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.SetGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class MapGenerator<K, V>
implements Generator<Map<K, V>> {
    private final Generator<Set<K>> keys;
    private final Generator<V> values;

    public MapGenerator(Generator<K> keys, Generator<V> values) {
        Objects.requireNonNull(keys, "keys");
        Objects.requireNonNull(values, "values");
        this.keys = new SetGenerator<K>(keys);
        this.values = values;
    }

    public MapGenerator(Generator<K> keys, Generator<V> values, Generator<Integer> size) {
        Objects.requireNonNull(keys, "keys");
        Objects.requireNonNull(values, "values");
        Objects.requireNonNull(size, "size");
        this.keys = new SetGenerator<K>(keys, size, 10);
        this.values = values;
    }

    @Override
    public Map<K, V> next() {
        HashMap<K, V> next = new HashMap<K, V>();
        for (K key : this.keys.next()) {
            next.put(key, this.values.next());
        }
        return next;
    }
}

