/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.generator.junit.parameterized;

import de.cuioss.test.generator.TypedGenerator;
import de.cuioss.test.generator.junit.parameterized.AbstractTypedGeneratorArgumentsProvider;
import de.cuioss.test.generator.junit.parameterized.TypeGeneratorFactorySource;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.ReflectionUtils;

public class TypeGeneratorFactoryArgumentsProvider
extends AbstractTypedGeneratorArgumentsProvider
implements AnnotationConsumer<TypeGeneratorFactorySource> {
    private Class<?> factoryClass;
    private String factoryMethod;
    private String[] methodParameters;
    private int count;

    public void accept(TypeGeneratorFactorySource annotation) {
        this.factoryClass = annotation.factoryClass();
        this.factoryMethod = annotation.factoryMethod();
        this.methodParameters = annotation.methodParameters();
        this.count = Math.max(1, annotation.count());
    }

    @Override
    protected Stream<? extends Arguments> provideArgumentsForGenerators(ExtensionContext context) {
        TypedGenerator<?> generator = this.createGeneratorFromFactory();
        return this.generateArguments(generator).stream();
    }

    @Override
    protected long getSeed() {
        return -1L;
    }

    @Override
    protected int getCount() {
        return this.count;
    }

    private TypedGenerator<?> createGeneratorFromFactory() {
        Objects.requireNonNull(this.factoryClass, "Factory class must not be null");
        Objects.requireNonNull(this.factoryMethod, "Factory method must not be null");
        try {
            Method method = this.findFactoryMethod();
            return (TypedGenerator)method.invoke(null, (Object[])this.methodParameters);
        }
        catch (Exception e) {
            throw new JUnitException("Failed to create TypedGenerator using factory method '" + this.factoryMethod + "' in class '" + this.factoryClass.getName() + "'", (Throwable)e);
        }
    }

    private Method findFactoryMethod() {
        List<Method> stringParamMethods;
        List<Method> candidateMethods = Arrays.stream(this.factoryClass.getMethods()).filter(m -> m.getName().equals(this.factoryMethod)).filter(ReflectionUtils::isStatic).filter(m -> m.getParameterCount() == this.methodParameters.length).filter(m -> TypedGenerator.class.isAssignableFrom(m.getReturnType())).toList();
        if (candidateMethods.isEmpty()) {
            throw new JUnitException("Could not find static factory method '" + this.factoryMethod + "' in class '" + this.factoryClass.getName() + "' with " + this.methodParameters.length + " parameters that returns TypedGenerator");
        }
        if (candidateMethods.size() > 1 && (stringParamMethods = candidateMethods.stream().filter(m -> Arrays.stream(m.getParameterTypes()).allMatch(p -> p == String.class)).toList()).size() == 1) {
            return stringParamMethods.getFirst();
        }
        return candidateMethods.getFirst();
    }
}

