/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.generator.internal.net.java.quickcheck.generator.support;

import de.cuioss.test.generator.internal.net.java.quickcheck.Generator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.ByteGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.DoubleGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.IntegerGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.LongGenerator;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.ObjectGeneratorImpl;
import de.cuioss.test.generator.internal.net.java.quickcheck.generator.support.StringGenerator;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class ObjectDefaultMappingGenerator<T>
extends ObjectGeneratorImpl<T> {
    private static final Map<Class<?>, Generator<?>> RETURN_TYPE_TO_GENERATOR = new HashMap();

    public ObjectDefaultMappingGenerator(Class<T> objectType) {
        super(objectType);
        this.mapMethodsToGenerators();
    }

    private static void map(Generator<?> generator, Class<?> ... classes) {
        for (Class<?> c : classes) {
            RETURN_TYPE_TO_GENERATOR.put(c, generator);
        }
    }

    private void mapMethodsToGenerators() {
        for (Method method : this.definition.getType().getMethods()) {
            Class<?> returnType = method.getReturnType();
            Generator<?> generator = RETURN_TYPE_TO_GENERATOR.get(returnType);
            if (generator == null && returnType.isInterface()) {
                generator = this.buildGenerator(returnType);
            }
            this.definition.defineMapping(method, generator);
        }
    }

    private <R> ObjectDefaultMappingGenerator<R> buildGenerator(Class<R> returnType) {
        return new ObjectDefaultMappingGenerator<R>(returnType);
    }

    static {
        ObjectDefaultMappingGenerator.map(new IntegerGenerator(), Integer.class, Integer.TYPE);
        ObjectDefaultMappingGenerator.map(new StringGenerator(), String.class);
        ObjectDefaultMappingGenerator.map(new LongGenerator(), Long.class, Long.TYPE);
        ObjectDefaultMappingGenerator.map(new DoubleGenerator(), Double.class, Double.TYPE, Number.class);
        ObjectDefaultMappingGenerator.map(new ByteGenerator(), Byte.TYPE, Byte.class);
    }
}

