/*
 * Decompiled with CFR 0.152.
 */
package de.cuioss.test.juli;

import de.cuioss.test.juli.ConfigurationKeys;
import de.cuioss.test.juli.TestLogLevel;
import de.cuioss.tools.string.MoreStrings;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

final class StaticLoggerConfigurator {
    private Properties fileSystemProperties;
    private final Map<String, String> defaultConfiguration = new ConcurrentHashMap<String, String>();

    StaticLoggerConfigurator() {
    }

    Optional<String> getStringProperty(String name) {
        if (MoreStrings.isEmpty((CharSequence)name)) {
            return Optional.empty();
        }
        if (System.getProperties().containsKey(name)) {
            return Optional.of(System.getProperty(name));
        }
        this.checkIfInitialized();
        if (this.fileSystemProperties.containsKey(name)) {
            return Optional.of(this.fileSystemProperties.getProperty(name));
        }
        if (this.defaultConfiguration.containsKey(name)) {
            return Optional.of(this.defaultConfiguration.get(name));
        }
        return Optional.empty();
    }

    Optional<Boolean> getBooleanProperty(String name) {
        Optional<String> propertyOption = this.getStringProperty(name);
        return propertyOption.map(Boolean::valueOf);
    }

    Map<String, TestLogLevel> getConfiguredLogger() {
        HashMap<String, TestLogLevel> found = new HashMap<String, TestLogLevel>();
        HashSet<String> loggerStrings = new HashSet<String>();
        this.checkIfInitialized();
        for (Object name : this.fileSystemProperties.keySet()) {
            if (!StaticLoggerConfigurator.startsWith(name, "cui.logger.")) continue;
            loggerStrings.add(name.toString());
        }
        for (Object name : System.getProperties().keySet()) {
            if (!StaticLoggerConfigurator.startsWith(name, "cui.logger.")) continue;
            loggerStrings.add(name.toString());
        }
        for (String config : loggerStrings) {
            found.put(config.substring("cui.logger.".length()), TestLogLevel.getLevelOrDefault(this.getStringProperty(config).get(), TestLogLevel.INFO));
        }
        return found;
    }

    TestLogLevel getRootLevel() {
        String configured = this.getStringProperty("cui.logging.root_log_level").orElse("");
        return TestLogLevel.getLevelOrDefault(configured, TestLogLevel.INFO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkIfInitialized() {
        if (null != this.fileSystemProperties) return;
        Class<StaticLoggerConfigurator> clazz = StaticLoggerConfigurator.class;
        synchronized (StaticLoggerConfigurator.class) {
            this.fileSystemProperties = new Properties();
            this.loadPropertyFile();
            ConfigurationKeys.populateDefaults(this.defaultConfiguration);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void loadPropertyFile() {
        try (InputStream in = AccessController.doPrivileged(() -> {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                return contextClassLoader.getResourceAsStream("cui_logger.properties");
            }
            return ClassLoader.getSystemResourceAsStream("cui_logger.properties");
        });){
            if (in != null) {
                this.fileSystemProperties.load(in);
            }
        }
        catch (IOException e1) {
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Unable to load configuration", e1);
        }
    }

    static boolean startsWith(Object toBeChecked, String search) {
        if (null == toBeChecked) {
            return false;
        }
        return MoreStrings.nullToEmpty((String)toBeChecked.toString()).startsWith(MoreStrings.nullToEmpty((String)search));
    }
}

